//
#include "SerialUart.h"
//
CSerialUart::CSerialUart(int pinrxd, int pintxd)
{
    FPinRxD = pinrxd;
    FPinTxD = pintxd;
    FPUart = new HardwareSerial(FPinRxD, FPinTxD);
    FRxCharacter = 0x00;
    FRxIndex = 0;
}

void CSerialUart::Open(int baudrate)
{
    FPUart->begin(baudrate);
    FRxIndex = 0;
}
//
void CSerialUart::WriteLine(void)
{
    FPUart->print("\r\n");
}
void CSerialUart::Write(const char* value)
{
    sprintf(FTxBuffer, "%s", value);
    FPUart->print(FTxBuffer);
}
void CSerialUart::Write(char* value)
{
    sprintf(FTxBuffer, "%s", value);
    FPUart->print(FTxBuffer);
}
void CSerialUart::Write(Int8 value)
{
    sprintf(FTxBuffer, "%i", value);
    FPUart->print(FTxBuffer);
}
void CSerialUart::Write(UInt8 value)
{
    sprintf(FTxBuffer, "%u", value);
    FPUart->print(FTxBuffer);
}
void CSerialUart::Write(Int16 value)
{
    sprintf(FTxBuffer, "%i", value);
    FPUart->print(FTxBuffer);
}
void CSerialUart::Write(UInt16 value)
{
    sprintf(FTxBuffer, "%u", value);
    FPUart->print(FTxBuffer);
}
void CSerialUart::Write(Int32 value)
{
    sprintf(FTxBuffer, "%i", value);
    FPUart->print(FTxBuffer);
}
void CSerialUart::Write(UInt32 value)
{
    sprintf(FTxBuffer, "%u", value);
    FPUart->print(FTxBuffer);
}
void CSerialUart::Write(Float32 value)
{
    sprintf(FTxBuffer, "%.3f", value);
    FPUart->print(FTxBuffer);
}
void CSerialUart::Write(Double64 value)
{
    sprintf(FTxBuffer, "%.6f", value);
    FPUart->print(FTxBuffer);
}
//
Boolean CSerialUart::ReadCharacter(Character &character)
{
    character = FRxCharacter;
    FRxCharacter = 0x00;
    return true;
}
Boolean CSerialUart::ReadLine(PCharacter pcharacter)
{
    strcpy(pcharacter, FRxBuffer);
    FRxIndex = 0;
    FRxBuffer[FRxIndex] = 0x00;
    return (0 < strlen(pcharacter));
}
//
Boolean CSerialUart::Execute(void)
{
    if (FPUart->available())
    {
        FRxCharacter = FPUart->read();
        if ((TOKEN_CR == FRxCharacter) ||
            (TOKEN_LF == FRxCharacter))
        {
            FRxBuffer[FRxIndex] = 0x00;
            FRxIndex = 0;
            return (0 < strlen(FRxBuffer));
        }
        else
        {
            FRxBuffer[FRxIndex] = FRxCharacter;
            FRxIndex++;
            FRxBuffer[FRxIndex] = 0x00;
        }
    }
    return false;
}