//
#include "Define.h"
#include "Helper.h"
#include "Pin.h"
#include "Led.h"
#include "SerialUart.h"
#include "Command.h"
//
extern Character BufferLine[];
extern CSerialUart UartA;
extern CLed LedSystem;
extern CCommand Command;
//
CCommand::CCommand(void)
{
    FCommand[0] = 0x00;
     FParameterCount = 0;
     FParameterA[0] = 0x00;
     FParameterB[0] = 0x00;
     FParameterC[0] = 0x00;
     FParameterD[0] = 0x00;
}
//
char* CCommand::GetCommand(void)
{
    return FCommand;
}
byte CCommand::GetParameterCount(void)
{
    return FParameterCount;
}
char* CCommand::GetParameterA(void)
{
    return FParameterA;
}
char* CCommand::GetParameterB(void)
{
    return FParameterB;
}
char* CCommand::GetParameterC(void)
{
    return FParameterC;
}
char* CCommand::GetParameterD(void)
{
    return FParameterD;
}
//
Boolean CCommand::Analyse(char* pline)
{
    const char* TOKEN_RXD = " \r\n\t";    
    char* Token;
    FCommand[0] = 0x00;
    FParameterCount = 0;
    FParameterA[0] = 0x00;
    FParameterB[0] = 0x00;
    FParameterC[0] = 0x00;
    FParameterD[0] = 0x00;
    Token = strtok(pline, TOKEN_RXD);
    if (NULL != Token)
    {
        strcpy(FCommand, Token);
        strupr(FCommand);
        FParameterCount = 0;
        Token = strtok(NULL, TOKEN_RXD);
        if (NULL != Token)
        {
            strcpy(FParameterA, Token);
            FParameterCount = 1;
            Token = strtok(NULL, TOKEN_RXD);
            if (NULL != Token)
            {
                strcpy(FParameterB, Token);
                FParameterCount = 2;
                Token = strtok(NULL, TOKEN_RXD);
                if (NULL != Token)
                {
                    strcpy(FParameterC, Token);
                    FParameterCount = 3;
                    Token = strtok(NULL, TOKEN_RXD);
                    if (NULL != Token)
                    {
                        strcpy(FParameterD, Token);
                        FParameterCount = 4;
                    }
                }
            }
        }
    }    
    return (0 < strlen(FCommand));
}
Boolean CCommand::Execute(void)
{ // <command>[<parameter>]0..4
    if (0 == strcmp("LSO", FCommand))
    {
        return AnalyseLedSystemOn();
    }
    if (0 == strcmp("LSF", FCommand))
    {        
        return AnalyseLedSystemOff();
    }
    if (0 == strcmp("LSB", FCommand))
    {        
        return AnalyseLedSystemBlink();
    }
    return false;    
}




Boolean CCommand::AnalyseLedSystemOn(void)
{ // ParameterABCD: -
    return OnLedSystemOn();
}

Boolean CCommand::AnalyseLedSystemOff(void)
{ // ParameterABCD: -
    return OnLedSystemOff();
}

Boolean CCommand::AnalyseLedSystemBlink(void)
{ // ParameterA:count ParameterB:ontime[ms] ParameterC:offtime[ms]
    if (GetParameterCount() < 3)
        return false;    
    int BC = atoi(GetParameterA());
    int TO = atoi(GetParameterB());
    int TF = atoi(GetParameterC());
    return OnLedSystemBlink(BC, TO, TF);
}


