//
#ifndef Command_h
#define Command_h
//
#include "Define.h"
#include "Helper.h"
//
const int SIZE_BUFFERCOMMAND = 16;
const int SIZE_BUFFERPARAMETER = 16;
//
class CCommand
{
    protected:
    char FCommand[SIZE_BUFFERCOMMAND];
    char FParameterA[SIZE_BUFFERPARAMETER];
    char FParameterB[SIZE_BUFFERPARAMETER];
    char FParameterC[SIZE_BUFFERPARAMETER];
    char FParameterD[SIZE_BUFFERPARAMETER];
    byte FParameterCount;
    //
    public:
    CCommand(void);
    //
    char* GetCommand(void);
    byte GetParameterCount(void);
    char* GetParameterA(void);
    char* GetParameterB(void);
    char* GetParameterC(void);
    char* GetParameterD(void);
    //
    Boolean Analyse(char* pline);
    Boolean Execute(void);
    //
    // System
    Boolean AnalyseSystemReset(void);
    // LedSystem
    Boolean AnalyseLedSystemOn(void);
    Boolean AnalyseLedSystemOff(void);
    Boolean AnalyseLedSystemBlink(void);
    //
};
//
#endif // Command_h
//