//
#include "Define.h"
#include "Helper.h"
#include "Pin.h"
#include "Led.h"
#include "SerialUart.h"
#include "Command.h"
//
extern Character BufferLine[];
//
CSerialUart UartA(PIN_SERIALA_RX, PIN_SERIALA_TX);
CLed LedSystem(PIN_LEDSYSTEM, true);
CCommand Command;


void Error(const char* text)
{
    sprintf(BufferLine, "!Error: %s!\r\n", text);
    UartA.Write(BufferLine);
}

void setup() 
{
    LedSystem.Open(sldOff);
    UartA.Open(115200);
    delay(330);
    UartA.Write("\r\n");
    UartA.Write("***************************\r\n");
    UartA.Write("* Stm32CommandDispatcher *\r\n");
    UartA.Write("**************************\r\n");
    UartA.Write("* Version: 00V05         *\r\n");
    UartA.Write("* Date...: 221203        *\r\n");
    UartA.Write("* Time...: 1108          *\r\n");
    UartA.Write("* Author.: OMdevelop     *\r\n");
    UartA.Write("**************************\r\n");
    //
}

void loop() 
{
    if (UartA.Execute())
    {
        if (UartA.ReadLine(BufferLine))
        {
            if (Command.Analyse(BufferLine))
            {
                if (false == Command.Execute())
                {
                    Error("Invalid Command-Execution");
                }
            }
        }
    }
}





//#############################################################

                // UartA.Write(Command.GetCommand());
                // UartA.WriteLine();
/*
            UartA.Write(">");
            UartA.Write(BufferLine);
            UartA.Write("<\r\n");
*/
    // sprintf(BufferLine, "asdfdsf\r\n");
    // UartA.Write(BufferLine);
    // strupr(BufferLine);
    // UartA.Write(BufferLine);

// debug  UartA.Write("C[");
// UartA.Write(Command.GetCommand());
// UartA.Write("]PA[");
// UartA.Write(Command.GetParameterA());
// UartA.Write("]PB[");
// UartA.Write(Command.GetParameterB());
// UartA.Write("]PC[");
// UartA.Write(Command.GetParameterC());
// UartA.Write("]PD[");
// UartA.Write(Command.GetParameterD());
// UartA.Write("]\r\n");

// SerialA.println(Counter);
// Counter++;
// // LedSystem.Set(sldOn);
// // delay(1000);
// // LedSystem.Set(sldOff);
// // delay(1000);
// LedSystem.Invert();
// delay(1000);  
