//
#include "Define.h"
#include "Helper.h"
#include "Pin.h"
#include "Led.h"
#include "SerialUart.h"
#include "Command.h"
//
extern Character BufferLine[];
//
extern CSerialUart UartA;
extern CLed LedSystem;
extern CCommand Command;
//
//--------------------------------
//  System
//--------------------------------
Boolean OnSystemHelp(bool response)
{   
    if (response)
    {
        Response("H");
    }        
    UartA.WriteLine("# Help : System");
    UartA.WriteLine("# H   - This Help");
    UartA.WriteLine("# RST - Reset");
    UartA.WriteLine("# Help : LedSystem");
    UartA.WriteLine("# LSO - SetOn");
    UartA.WriteLine("# LSF - SetOff");
    UartA.WriteLine("# LSI - Invert");
    UartA.WriteLine("# LSB <c> <o> <f> - Blink <c>ount Time<o>n[ms] TimeO<f>f[ms]");
    return true;
}
Boolean OnSystemReset(void)
{   
    Response("RST");
    delay(1000);
    NVIC_SystemReset();
    return true;
}
//--------------------------------
//  LedSystem
//--------------------------------
Boolean OnLedSystemOn(void)
{   
    LedSystem.Set(sldOn);       
    Response("LSO");
    return true;
}
Boolean OnLedSystemOff(void)
{
    LedSystem.Set(sldOff);
    Response("LSF");
    return true;
}
Boolean OnLedSystemInvert(void)
{
    LedSystem.Invert();
    Response("LSI");
    return true;
}
Boolean OnLedSystemBlink(UInt32 count, UInt32 timeon, UInt32 timeoff)
{
    sprintf(BufferLine, "LSB %i %i %i", count, timeon, timeoff);
    Response(BufferLine);    
    return LedSystem.Blink(count, timeon, timeoff);
}

