//
#include "Led.h"

//
#include "Define.h"
#include "Helper.h"
#include "SerialUart.h"
//
extern char LineBuffer[];
extern CSerialUart UartA;

CLed::CLed(int pin, bool inverted)
{
    FState = sldOff;
    FPin = pin;
    FInverted = inverted;
    FCount = 0;
    FTimeOn = 1;
    FTimeOff = 1;
    FTicksPreset = millis();
}
//
void CLed::Open(EStateLed state)
{
    pinMode(FPin, OUTPUT);
    Set(state);
}
//
void CLed::Abort(void)
{
    FCount = 0;
    FTimeOn = 1;
    FTimeOff = 1;
    Set(sldOff);
}
//
void CLed::Set(EStateLed state)
{
    FState = state;
    if (FInverted)
    {
        if (sldOn == FState)
        {
            digitalWrite(FPin, LOW);
            Event("LSO");
        }
        else
        {
            digitalWrite(FPin, HIGH);
            Event("LSF");
        }
    }
    else
    {
        if (sldOn == FState)
        {
            digitalWrite(FPin, HIGH);
            Event("LSO");
        }
        else
        {
            digitalWrite(FPin, LOW);
            Event("LSF");
        }
    }
}
//
EStateLed CLed::Get(void)
{    
    return FState;
}
//
EStateLed CLed::Invert(void)
{
    if (sldOff == Get())
    {
        Set(sldOn);
    }
    else
    {
        Set(sldOff);
    }
    return Get();
}
//
Boolean CLed::Blink(UInt32 count, UInt32 timeon, UInt32 timeoff)
{
    FCount = max((UInt32)1, count);
    FTimeOn = timeon;
    FTimeOff = timeoff;
    FTicksPreset = millis();
    Set(sldOn);
    return true;
}

void CLed::Execute(void)
{
    if (0 < FCount)
    {
        if ((sldOn == Get()) && (FTicksPreset + FTimeOn) <= millis())
        {
            Set(sldOff);
        } 
        else
        if ((sldOff == Get()) && (FTicksPreset + FTimeOn + FTimeOff) <= millis())
        {
            FTicksPreset = millis();
            FCount--;
            if (0 < FCount)
            {
                Set(sldOn);
            }
        }
    }
}

