//
#include "Define.h"
#include "Helper.h"
#include "Pin.h"
#include "Led.h"
#include "SerialUart.h"
#include "Command.h"
#include "System.h"
//
extern Character BufferLine[];
//
CSerialUart UartA(PIN_SERIALA_RX, PIN_SERIALA_TX);
CSerialUart* PUartSystem;
CLed LedSystem(PIN_LEDSYSTEM, true);
CCommand Command;
CSystem System;


void Error(const char* text)
{
    sprintf(BufferLine, "!Error: %s!\r\n", text);
    UartA.Write(BufferLine);
}

void setup() 
{
    PUartSystem = &UartA;
    //
    LedSystem.Open(sldOff);
    UartA.Open(115200);
    delay(330);
    UartA.Write("\r\n");
    UartA.Write("**************************\r\n");
    UartA.Write("* Stm32CommandDispatcher *\r\n");
    UartA.Write("**************************\r\n");
    UartA.Write("* Version: 01V01         *\r\n");
    UartA.Write("* Date...: 221206        *\r\n");
    UartA.Write("* Time...: 1845          *\r\n");
    UartA.Write("* Author.: OMdevelop     *\r\n");
    UartA.Write("**************************\r\n");
    //
    OnSystemHelp();
    //
    System.Open(1000);
}

void loop() 
{
    if (UartA.Execute())
    {
        if (UartA.ReadLine(BufferLine))
        {
            if (Command.Analyse(BufferLine))
            {
                if (false == Command.Execute())
                {
                    Error("Invalid Command-Execution");
                }
            }
        }
    }
    System.Execute();
    LedSystem.Execute();    
}
//
