//
#ifndef Led_h
#define Led_h
//
#include <Arduino.h>
#include "Define.h"
//
enum EStateLed
{
    sldOff = 0,
    sldOn = 1
};
//
class CLed
{
    private:
    EStateLed FState;
    int FPin;
    bool FInverted;
    //
    UInt32 FCount;
    UInt32 FTimeOn;
    UInt32 FTimeOff;
    UInt32 FTicksPreset;
    //
    public:
    CLed(int pin, bool inverted);
    //
    void Open(EStateLed state);
    void Abort(void);
    //
    void Set(EStateLed state);
    EStateLed Get(void);
    EStateLed Invert(void);
    //
    Boolean Blink(UInt32 count, UInt32 timeon, UInt32 timeoff);
    void Execute(void);
};
//
#endif // Led_h
//