//
#include "Define.h"
#include "Helper.h"
#include "Led.h"
#include "SerialUart.h"
#include "System.h"
//
extern Character BufferLine[];
extern CSerialUart* PUartSystem;
extern CLed LedSystem;
//
CSystem::CSystem(void)
{
    FRefreshInterval = INIT_REFRESHINTERVAL;
}
    
void CSystem::Open(UInt32 interval)
{
    FRefreshInterval = interval;
}    
//
void CSystem::SetRefreshInterval(UInt32 time)
{
    FRefreshInterval = time;
}
//
void CSystem::Execute(void)
{   
    if (FTicksPreset < millis()) 
    {
        FTicksPreset = millis() + FRefreshInterval;
        sprintf(BufferLine, "!SYS %lu %u", millis(), (int)LedSystem.Get());
        PUartSystem->WriteLine(BufferLine);
    }
}
