#include <Arduino.h>
#include "PCF8574.h"
//
//#define DEVICE_MASTER
#define DEVICE_SLAVE
//
//const byte I2CADDRESS_MASTER = 0x30;
const byte I2CADDRESS_SLAVE  = 0x40;
//
const int PIN_LEDSYSTEM = PC13;
#if defined(DEVICE_MASTER)
const int I2C1_SDA = PB7;
const int I2C1_SCL = PB6;
#endif
#if defined(DEVICE_SLAVE)
const int I2C1_SDA = PB7;
const int I2C1_SCL = PB6;
#endif
//
TwoWire I2CA(I2C1_SDA, I2C1_SCL);
//
#if defined(DEVICE_SLAVE)
void I2COnEvent(int count)
{
  Serial2.print("OnReceived[");
  while (0 < I2CA.available())
  {
    byte RxData = I2CA.read();
    Serial2.print("0x");
    Serial2.print(RxData, HEX);
    if (0x00 < RxData)
    {
      digitalWrite(PIN_LEDSYSTEM, LOW);
    }
    else
    {
      digitalWrite(PIN_LEDSYSTEM, HIGH);
    }    
  }
  Serial2.println("]");
}
#endif
//
void setup() 
{ //
  Serial2.begin(115200);
  delay(1000);
#if defined(DEVICE_MASTER)
  Serial2.println("*** DEVICE_MASTER");
#endif
#if defined(DEVICE_SLAVE)
  Serial2.println("*** DEVICE_SLAVE");
#endif
  //
  pinMode(PIN_LEDSYSTEM, OUTPUT);  
  digitalWrite(PIN_LEDSYSTEM, LOW);
  //
#if defined(DEVICE_MASTER)
  I2CA.begin(); 
#endif
#if defined(DEVICE_SLAVE)
  I2CA.begin(I2CADDRESS_SLAVE);
  I2CA.onReceive(I2COnEvent);
#endif
}
//
void loop() 
{ //
#if defined(DEVICE_MASTER)
  digitalWrite(PIN_LEDSYSTEM, LOW);
  Serial2.println("Send 0xFF");
  I2CA.beginTransmission(I2CADDRESS_SLAVE);
  I2CA.write(0xFF);
  I2CA.endTransmission();
#endif
#if defined(DEVICE_SLAVE)
#endif
  delay(1000);
  //
#if defined(DEVICE_MASTER)
  digitalWrite(PIN_LEDSYSTEM, HIGH);
  Serial2.println("Send 0x00");
  I2CA.beginTransmission(I2CADDRESS_SLAVE);
  I2CA.write(0x00);
  I2CA.endTransmission();
#endif
#if defined(DEVICE_SLAVE)
#endif
  delay(1000);
}
































// const int PIN_LEDSYSTEM = PC13;
// const int I2C1_SDA = PB7;
// const int I2C1_SCL = PB6;
// // I2CB const int I2C2_SDA = PB11;
// // I2CB const int I2C2_SCL = PB10;
// //
// const byte I2CADDRESS_MASTER = 0x30;
// const byte I2CADDRESS_SLAVE  = 0x40;
// //
// TwoWire I2CA(I2C1_SDA, I2C1_SCL);
// // I2CB TwoWire I2CB(I2C2_SDA, I2C2_SCL);
// //
// // NC PCF8574 PCF8574Device(0x38, &I2CA);
// // NC  I2CB PCF8574 PCF8574Device(0x38, &I2CB);
// //
// void I2COnEvent(int count)
// {
//   while (0 < I2CA.available())
//   {
//     byte RxData = I2CA.read();
//     Serial2.print("RxData: ");
//     Serial2.println(RxData, HEX);
//     if (RxData)
//     {
//       digitalWrite(PIN_LEDSYSTEM, LOW);
//     }
//     else
//     {
//       digitalWrite(PIN_LEDSYSTEM, HIGH);
//     }
    
//   }
// }
// //
// void setup() 
// {
//   Serial2.begin(115200);
//   //
//   pinMode(PIN_LEDSYSTEM, OUTPUT);  
//   digitalWrite(PIN_LEDSYSTEM, LOW);
//   //
// #if defined(DEVICE_MASTER)
//   I2CA.begin(I2CADDRESS_MASTER);
// #elif defined(DEVICE_SLAVE)
//   I2CA.begin(I2CADDRESS_SLAVE);
// #endif
//   I2CA.onReceive(I2COnEvent);
// }
// //
// void loop() 
// { //
// #if defined(DEVICE_MASTER)
//   I2CA.beginTransmission(I2CADDRESS_SLAVE);
// #elif defined(DEVICE_SLAVE)
//   I2CA.beginTransmission(I2CADDRESS_MASTER);
// #endif
//   I2CA.write(0xFF);
//   I2CA.endTransmission();
//   delay(1000);
//   //
// #if defined(DEVICE_MASTER)
//   I2CA.beginTransmission(I2CADDRESS_SLAVE);
// #elif defined(DEVICE_SLAVE)
//   I2CA.beginTransmission(I2CADDRESS_MASTER);
// #endif
//   I2CA.write(0x00);
//   I2CA.endTransmission();
//   delay(1000);
// }

