#include <Arduino.h>
#include "PCF8574.h"
//
//#define DEVICE_MASTER
#define DEVICE_SLAVE
//
const byte I2CADDRESS_MASTER = 0x30;
const byte I2CADDRESS_SLAVE  = 0x40;
//
const int PIN_LEDSYSTEM = PC13;
#if defined(DEVICE_MASTER)
const int I2C1_SDA = PB7;
const int I2C1_SCL = PB6;
#endif
#if defined(DEVICE_SLAVE)
const int I2C1_SDA = PB7;
const int I2C1_SCL = PB6;
#endif
//
TwoWire I2CA(I2C1_SDA, I2C1_SCL);
//
byte State = 0x55;
//
void I2COnRequest(void)
{
  Serial2.print("OnRequest[0x");
  if (0x55 == State)
  {
    State = 0xAA;
    Serial2.print(State, HEX);
    I2CA.write((byte)State);
  }
  else
  {
    State = 0x55;
    Serial2.print(State, HEX);
    I2CA.write((byte)State);
  }
  Serial2.println("]");
}
//
void I2COnReceive(int count)
{
  Serial2.print("OnReceive[");
  while (0 < I2CA.available())
  {
    byte RxData = I2CA.read();
    Serial2.print("0x");
    Serial2.print(RxData, HEX);
    if (0x00 < RxData)
    {
      digitalWrite(PIN_LEDSYSTEM, LOW);
    }
    else
    {
      digitalWrite(PIN_LEDSYSTEM, HIGH);
    }    
  }
  Serial2.println("]");
}
//
void setup() 
{ //
  Serial2.begin(115200);
  delay(1000);
#if defined(DEVICE_MASTER)
  Serial2.println("*** DEVICE_MASTER");
#endif
#if defined(DEVICE_SLAVE)
  Serial2.println("*** DEVICE_SLAVE");
#endif
  //
  pinMode(PIN_LEDSYSTEM, OUTPUT);  
  digitalWrite(PIN_LEDSYSTEM, LOW);
  //
#if defined(DEVICE_MASTER)
  I2CA.begin(); 
  I2CA.onRequest(I2COnRequest);
  I2CA.onReceive(I2COnReceive);
#endif
#if defined(DEVICE_SLAVE)
  I2CA.begin(I2CADDRESS_SLAVE);
  I2CA.onRequest(I2COnRequest);
  I2CA.onReceive(I2COnReceive);
#endif
}
//
void loop() 
{ //
#if defined(DEVICE_MASTER)
  Serial2.println("Send 0xFF to Slave");
  I2CA.beginTransmission(I2CADDRESS_SLAVE);
  I2CA.write(0xFF);
  I2CA.endTransmission();
#endif
#if defined(DEVICE_SLAVE)
  // NC Serial2.println("Send 0x00 to Master");
  // NC I2CA.beginTransmission(I2CADDRESS_MASTER);
  // NC I2CA.write(0x00);
  // NC I2CA.endTransmission();
#endif
  delay(2000);
  //
#if defined(DEVICE_MASTER)
  Serial2.println("Send 0x00 to Slave");
  I2CA.beginTransmission(I2CADDRESS_SLAVE);
  I2CA.write(0x00);
  I2CA.endTransmission();
#endif
#if defined(DEVICE_SLAVE)
  // NC Serial2.println("Send 0x00 to Master");
  // NC I2CA.beginTransmission(I2CADDRESS_MASTER);
  // NC I2CA.write(0x00);
  // NC I2CA.endTransmission();
#endif
  delay(2000);
//
#if defined(DEVICE_MASTER)
  Serial2.print("Request data from Slave - ");
  I2CA.requestFrom((int)I2CADDRESS_SLAVE, (int)1);
  if (0 < I2CA.available())
  {
    while (I2CA.available())
    {
      char C = I2CA.read();
      Serial2.print("0x");
      Serial2.println(C, HEX);
    }
  } 
  else
  {
    Serial2.println("<missing>");
  }
#endif
#if defined(DEVICE_SLAVE)
  // NC Serial2.println("Request data from Master");
  // NC I2CA.requestFrom((int)I2CADDRESS_MASTER, (int)1);
#endif
  delay(2000);
}
//