#
import time
#
import BluetoothUart as BTU
#
#-----------------------------------------------------------------------
#   Check Esp32Bluetooth
#-----------------------------------------------------------------------
def BtOnLineReceived(rxline):
    print('BtOnLineReceived[{}]'.format(rxline))
#
def BtOnLineTransmitted(txline):
    print('BtOnLineTransmitted[{}]'.format(txline))
#
if __name__ == "__main__":
    print('Esp32BtThread: begin')
    BtUart = BTU.CBtUart()
    BtUart.SetOnLineReceived(BtOnLineReceived)
    BtUart.SetOnLineTransmitted(BtOnLineTransmitted)
    # 
    nums = [4, 8, 15, 16, 23, 42]
    i = 0
    #
    try:
        while True:
            BtUart.write(str(nums[i]) + "\n")
            i = (i + 1) % len(nums)
            time.sleep_ms(500)
    except KeyboardInterrupt:
        pass
    #
    BtUart.close()
    print('Esp32BtThread: end')
    #
#