#
import time as TIM
import bluetooth as BLU
#
import BtUart as BTU
# 
#-------------------------------------------------------------------------
#   Main - Callback
#-------------------------------------------------------------------------
def BtUartAD_OnTxLine(txline):
    print('OnTxLine[{}]'.format(txline))
    return txline
#
def BtUartAD_OnRxLine(rxline):
    print('OnRxLine[{}]'.format(rxline))
    return 
#
#-------------------------------------------------------------------------
#   Main 
#-------------------------------------------------------------------------
if __name__ == "__main__":
    #
    print('Esp32BtTxRxLine: begin')
    #
    BLE = BLU.BLE()
    BtUartAD = BTU.CBtUart(BLE, BtUartAD_OnTxLine, BtUartAD_OnRxLine, "Esp32BtUart", rxbuffersize=100)
    BtUartAD.Open()
    #
    nums = [4, 8, 15, 16, 23, 42]
    i = 0
    try:
        while True:
            BtUartAD.TxLine(str(nums[i]))
            i = (i + 1) % len(nums)
            TIM.sleep_ms(1000)
    except KeyboardInterrupt:
        pass
    #
    BtUartAD.Close()
    #
    print('Esp32BtTxRxLine: end')
    #
#    