#
import time
from machine import Pin
#
import Define as DEF
import Thread as THR
#
class CKeyboard4x4():
    #-----------------------------------------------------------------
    #   Constructor
    #-----------------------------------------------------------------
    def __init__(self, \
                 pinin0, pinin1, pinin2, pinin3, \
                 pinout0, pinout1, pinout2, pinout3):
        #
        self.CountRepeat = 3
        #
        self.PinIn = []
        self.PinIn.append(Pin(pinin0, mode=Pin.IN, pull=Pin.PULL_DOWN))
        self.PinIn.append(Pin(pinin1, mode=Pin.IN, pull=Pin.PULL_DOWN))
        self.PinIn.append(Pin(pinin2, mode=Pin.IN, pull=Pin.PULL_DOWN))
        self.PinIn.append(Pin(pinin3, mode=Pin.IN, pull=Pin.PULL_DOWN))
        #
        self.PinOut = []
        self.PinOut.append(Pin(pinout0, mode=Pin.OUT, pull=Pin.PULL_DOWN))
        self.PinOut.append(Pin(pinout1, mode=Pin.OUT, pull=Pin.PULL_DOWN))
        self.PinOut.append(Pin(pinout2, mode=Pin.OUT, pull=Pin.PULL_DOWN))
        self.PinOut.append(Pin(pinout3, mode=Pin.OUT, pull=Pin.PULL_DOWN))
        #
        self.Thread = THR.CThread(self.CBOnStart, self.CBOnBusy, self.CBOnAbort, self.CBOnEnd)
        return
    #
    #-----------------------------------------------------------------
    #   Callback
    #-----------------------------------------------------------------
    def CBOnStart(self, thread):
        return
    def CBOnBusy(self, thread):
        while (THR.stBusy == self.Thread.State):
            self.PinOut[0].on()
            self.PinOut[1].off()
            self.PinOut[2].off()
            self.PinOut[3].off()
            KeyCode = 0x00
            CS0 = 0
            CS1 = 0
            CS2 = 0
            CS3 = 0
            for SI in range(0, self.CountRepeat):
                CS0 += self.PinIn[0].value()
                CS1 += self.PinIn[1].value()
                CS2 += self.PinIn[2].value()
                CS3 += self.PinIn[3].value()
                time.sleep(0.03)
            if (self.CountRepeat <= CS0):
                KeyCode = 0x11
            if (self.CountRepeat <= CS1):
                KeyCode = 0x21
            if (self.CountRepeat <= CS2):
                KeyCode = 0x41
            if (self.CountRepeat <= CS3):
                KeyCode = 0x81
            if (0 < KeyCode):
                print(KeyCode)
        return
    def CBOnAbort(self, thread):
        return
    def CBOnEnd(self, thread):
        return
    #-----------------------------------------------------------------
    #   Manager
    #-----------------------------------------------------------------
    def Open(self):
        self.Thread.Start()
        return 
    def Close(self):
        self.Thread.Abort()
        return 
#

#
#------------------------------------------------------------------
#   Main
#------------------------------------------------------------------
if '__main__' == __name__:
    print('*** Check Keyboard4x4: begin')
    #
    Keyboard = CKeyboard4x4(DEF.PIN_KEYBOARD_IN0, DEF.PIN_KEYBOARD_IN1, 
                            DEF.PIN_KEYBOARD_IN2, DEF.PIN_KEYBOARD_IN3, 
                            DEF.PIN_KEYBOARD_OUT0, DEF.PIN_KEYBOARD_OUT1, 
                            DEF.PIN_KEYBOARD_OUT2, DEF.PIN_KEYBOARD_OUT3)
    #
    Keyboard.Open()
    time.sleep(10.0)
    Keyboard.Close()
    #
    print('*** Check Keyboard4x4: end')
    #
#
