#
import time
from machine import Pin
#
import Define as DEF
import Thread as THR
#
SIZE_KEYCODEBUFFER = 5
TIME_KEYPRESSED = 0.1
TIME_KEYREPETITION = 0.5
#
class CKeyboard4x4():
    #-----------------------------------------------------------------
    #   Constructor
    #-----------------------------------------------------------------
    def __init__(self, \
                 pinin0, pinin1, pinin2, pinin3, \
                 pinout0, pinout1, pinout2, pinout3):
        #
        self.CountRepeat = 3
        self.KeySleep = 0.001
        #
        self.PinIn = []
        self.PinIn.append(Pin(pinin0, mode=Pin.IN, pull=Pin.PULL_DOWN))
        self.PinIn.append(Pin(pinin1, mode=Pin.IN, pull=Pin.PULL_DOWN))
        self.PinIn.append(Pin(pinin2, mode=Pin.IN, pull=Pin.PULL_DOWN))
        self.PinIn.append(Pin(pinin3, mode=Pin.IN, pull=Pin.PULL_DOWN))
        #
        self.PinOut = []
        self.PinOut.append(Pin(pinout0, mode=Pin.OUT, pull=Pin.PULL_DOWN))
        self.PinOut.append(Pin(pinout1, mode=Pin.OUT, pull=Pin.PULL_DOWN))
        self.PinOut.append(Pin(pinout2, mode=Pin.OUT, pull=Pin.PULL_DOWN))
        self.PinOut.append(Pin(pinout3, mode=Pin.OUT, pull=Pin.PULL_DOWN))
        #
        self.Thread = THR.CThread(self.CBOnStart, self.CBOnBusy, self.CBOnAbort, self.CBOnEnd)
        #
        self.KeyCodes = []
        return
    #
    #-----------------------------------------------------------------
    #   Callback
    #-----------------------------------------------------------------
    def CBOnStart(self, thread):
        return
    def CBOnBusy(self, thread):
        while (THR.stBusy == self.Thread.State):
            KeyCode0 = 0x00
            KeyCode1 = 0x00
            KeyCode2 = 0x00
            KeyCode3 = 0x00
            #-----------------------------------------
            # Row0
            #-----------------------------------------
            self.PinOut[0].on()
            self.PinOut[1].off()
            self.PinOut[2].off()
            self.PinOut[3].off()
            CS0 = 0
            CS1 = 0
            CS2 = 0
            CS3 = 0
            for SI in range(0, self.CountRepeat):
                CS0 += self.PinIn[0].value()
                CS1 += self.PinIn[1].value()
                CS2 += self.PinIn[2].value()
                CS3 += self.PinIn[3].value()
                time.sleep(self.KeySleep)
            if (self.CountRepeat <= CS0):
                KeyCode0 = 0x11
            if (self.CountRepeat <= CS1):
                KeyCode0 = 0x21
            if (self.CountRepeat <= CS2):
                KeyCode0 = 0x41
            if (self.CountRepeat <= CS3):
                KeyCode0 = 0x81
            #-----------------------------------------
            # Row1
            #-----------------------------------------
            self.PinOut[0].off()
            self.PinOut[1].on()
            self.PinOut[2].off()
            self.PinOut[3].off()
            CS0 = 0
            CS1 = 0
            CS2 = 0
            CS3 = 0
            for SI in range(0, self.CountRepeat):
                CS0 += self.PinIn[0].value()
                CS1 += self.PinIn[1].value()
                CS2 += self.PinIn[2].value()
                CS3 += self.PinIn[3].value()
                time.sleep(self.KeySleep)
            if (self.CountRepeat <= CS0):
                KeyCode1 = 0x12
            if (self.CountRepeat <= CS1):
                KeyCode1 = 0x22
            if (self.CountRepeat <= CS2):
                KeyCode1 = 0x42
            if (self.CountRepeat <= CS3):
                KeyCode1 = 0x82
            #-----------------------------------------
            # Row2
            #-----------------------------------------
            self.PinOut[0].off()
            self.PinOut[1].off()
            self.PinOut[2].on()
            self.PinOut[3].off()
            CS0 = 0
            CS1 = 0
            CS2 = 0
            CS3 = 0
            for SI in range(0, self.CountRepeat):
                CS0 += self.PinIn[0].value()
                CS1 += self.PinIn[1].value()
                CS2 += self.PinIn[2].value()
                CS3 += self.PinIn[3].value()
                time.sleep(self.KeySleep)
            if (self.CountRepeat <= CS0):
                KeyCode2 = 0x14
            if (self.CountRepeat <= CS1):
                KeyCode2 = 0x24
            if (self.CountRepeat <= CS2):
                KeyCode2 = 0x44
            if (self.CountRepeat <= CS3):
                KeyCode2 = 0x84
            #-----------------------------------------
            # Row3
            #-----------------------------------------
            self.PinOut[0].off()
            self.PinOut[1].off()
            self.PinOut[2].off()
            self.PinOut[3].on()
            CS0 = 0
            CS1 = 0
            CS2 = 0
            CS3 = 0
            for SI in range(0, self.CountRepeat):
                CS0 += self.PinIn[0].value()
                CS1 += self.PinIn[1].value()
                CS2 += self.PinIn[2].value()
                CS3 += self.PinIn[3].value()
                time.sleep(self.KeySleep)
            if (self.CountRepeat <= CS0):
                KeyCode3 = 0x18
            if (self.CountRepeat <= CS1):
                KeyCode3 = 0x28
            if (self.CountRepeat <= CS2):
                KeyCode3 = 0x48
            if (self.CountRepeat <= CS3):
                KeyCode3 = 0x88
            #
            if (0 < KeyCode0):
                self.KeyCodes.append(KeyCode0)
            if (0 < KeyCode1):
                self.KeyCodes.append(KeyCode1)
            if (0 < KeyCode2):
                self.KeyCodes.append(KeyCode2)
            if (0 < KeyCode3):
                self.KeyCodes.append(KeyCode3)
            #
            while (SIZE_KEYCODEBUFFER < len(self.KeyCodes)):
                self.KeyCodes.pop(0)
            #
            if (0 < len(self.KeyCodes)):
                time.sleep(TIME_KEYREPETITION)
            else:
                time.sleep(TIME_KEYPRESSED)
        return
    def CBOnAbort(self, thread):
        return
    def CBOnEnd(self, thread):
        return
    #-----------------------------------------------------------------
    #   Manager
    #-----------------------------------------------------------------
    def Open(self):
        self.Thread.Start()
        return 
    def Close(self):
        self.Thread.Abort()
        return 
    def GetKeyCode(self):
        if (0 < len(self.KeyCodes)):
            KC = self.KeyCodes.pop(0)
            return KC
        return 0
#
#------------------------------------------------------------------
#   Check Library
#------------------------------------------------------------------
if '__main__' == __name__:
    print('*** Check Keyboard4x4: begin')
    #
    Keyboard = CKeyboard4x4(DEF.PIN_KEYBOARD_IN0, DEF.PIN_KEYBOARD_IN1, 
                            DEF.PIN_KEYBOARD_IN2, DEF.PIN_KEYBOARD_IN3, 
                            DEF.PIN_KEYBOARD_OUT0, DEF.PIN_KEYBOARD_OUT1, 
                            DEF.PIN_KEYBOARD_OUT2, DEF.PIN_KEYBOARD_OUT3)
    # Open
    Keyboard.Open()
    # MainLoop ....
    for I in range(0, 10000):
        KC = Keyboard.GetKeyCode()
        if (0 < KC):
            print(KC)
        time.sleep(0.001)
    # Close
    Keyboard.Close()
    #
    print('*** Check Keyboard4x4: end')
    #
#
