#
import machine
import time
#
import Define as DEF
import Thread as THR
import LCDisplayI2C as LCD
#
class CCommandDisplay():
    def __init__(self, lcdisplay):
        self.LCDisplay = lcdisplay
        return
    #
    def Execute(self):
        return
    #
class CClear(CCommandDisplay):
    def __init__(self, lcdisplay):
        super(CClear, self).__init__(lcdisplay)
        return
    def Execute(self):
        self.LCDisplay.Clear()
        return
#
class CWrite(CCommandDisplay):
    def __init__(self, lcdisplay, row, col, text):
        super(CWrite, self).__init__(lcdisplay)
        self.Row = row
        self.Col = col
        self.Text = text
        return
    def Execute(self):
        self.LCDisplay.MoveTo(self.Row, self.Col)
        self.LCDisplay.PutText(self.Text)
        return
#
class CThreadDisplay(THR.CThread):
    #
    def __init__(self, i2cdisplay, lcdisplay):
        super(CThreadDisplay, self).__init__(self.OnStart, self.OnBusy, self.OnAbort, self.OnEnd)
        self.I2CDisplay = i2cdisplay
        self.LCDisplay = lcdisplay
        self.CommandList = []
        return
    #---------------------------------------------
    def OnStart(self, thread):
        return
    def OnBusy(self, thread):
        while (THR.stBusy == thread.State):
            self.Clear()
            Col = 0
            while (Col <= 19):
                self.Write(0, Col, ' Hello0')
                self.Write(1, Col, ' Hello1')
                self.Write(2, Col, ' Hello2')
                self.Write(3, Col, ' Hello3')
                while (0 < len(self.CommandList)):
                    Command = self.CommandList.pop(0)
                    Command.Execute()
                time.sleep(0.5)
                Col += 1
                if (THR.stBusy != thread.State):
                    break
        return
    def OnAbort(self, thread):
        return
    def OnEnd(self, thread):
        return
    #---------------------------------------------
    def Open(self):
        self.Start()
        return
    def Close(self):
        self.Abort()
        return
    #---------------------------------------------
    def Clear(self):
        self.CommandList.append(CClear(self.LCDisplay))
        return 
    def Write(self, row, col, text):
        self.CommandList.append(CWrite(self.LCDisplay, row, col, text))
        return
    #
#
#------------------------------------------------------------------------------------------
if ('__main__' == __name__):
    print('*** CheckEsp32DisplayKey: begin')    
    #
    I2CDisplay = machine.SoftI2C(scl=machine.Pin(22), sda=machine.Pin(21), freq=2000000) 
    LCDisplay = LCD.CLCDisplayI2C(I2CDisplay, DEF.I2CADDRESS_LCDISPLAY_T, \
                                  DEF.LCDISPLAY_COUNT_ROWS, DEF.LCDISPLAY_COUNT_COLUMNS)
    TD = CThreadDisplay(I2CDisplay, LCDisplay)
    TD.Open()
    #
    time.sleep(10.0)
    #
    TD.Close()
    #
    print('*** CheckEsp32DisplayKey: end')
    #
#
