#
import time
import machine
#
import Define as DEF
import Thread as THR
import LCDisplayI2C as LCD
import ThreadDisplay as TDP
import Keyboard4x4 as KBD
#
#
#------------------------------------------------------------------
#   Main
#------------------------------------------------------------------
if ('__main__' == __name__):
    print('*** CheckEsp32DisplayKey: begin')
    #
    # Display
    I2CDisplay = machine.SoftI2C(scl=machine.Pin(22), sda=machine.Pin(21), freq=2000000) 
    LCDisplay = LCD.CLCDisplayI2C(I2CDisplay, DEF.I2CADDRESS_LCDISPLAY_T, \
                                  DEF.LCDISPLAY_COUNT_ROWS, DEF.LCDISPLAY_COUNT_COLUMNS)
    ThreadDisplay = TDP.CThreadDisplay(I2CDisplay, LCDisplay)
    # Keyboard
    Keyboard = KBD.CKeyboard4x4(DEF.PIN_KEYBOARD_IN0, DEF.PIN_KEYBOARD_IN1, 
                                DEF.PIN_KEYBOARD_IN2, DEF.PIN_KEYBOARD_IN3, 
                                DEF.PIN_KEYBOARD_OUT0, DEF.PIN_KEYBOARD_OUT1, 
                                DEF.PIN_KEYBOARD_OUT2, DEF.PIN_KEYBOARD_OUT3)
    # Open
    ThreadDisplay.Open()
    Keyboard.Open()
    #
    # MainLoop ....
    for I in range(0, 10000):
        KC = Keyboard.GetKeyCode()
        if (0 < KC):
            print(KC)
        time.sleep(0.001)
    #
    # Close
    Keyboard.Close()
    ThreadDisplay.Close()
    #
    print('*** CheckEsp32DisplayKey: end')
    #
#