#
import time
from machine import Pin
#
import Define as DEF
import Thread as THR
#
class CKeyboard4x4():
    #-----------------------------------------------------------------
    #   Constructor
    #-----------------------------------------------------------------
    def __init__(self, \
                 pinin0, pinin1, pinin2, pinin3, \
                 pinout0, pinout1, pinout2, pinout3,
                 onkeyevent):
        #
        self.CountRepeat = 3
        #
        self.PinIn = []
        self.PinIn.append(Pin(pinin0, mode=Pin.IN, pull=Pin.PULL_DOWN))
        self.PinIn.append(Pin(pinin1, mode=Pin.IN, pull=Pin.PULL_DOWN))
        self.PinIn.append(Pin(pinin2, mode=Pin.IN, pull=Pin.PULL_DOWN))
        self.PinIn.append(Pin(pinin3, mode=Pin.IN, pull=Pin.PULL_DOWN))
        #
        self.PinOut = []
        self.PinOut.append(Pin(pinout0, mode=Pin.OUT, pull=Pin.PULL_DOWN))
        self.PinOut.append(Pin(pinout1, mode=Pin.OUT, pull=Pin.PULL_DOWN))
        self.PinOut.append(Pin(pinout2, mode=Pin.OUT, pull=Pin.PULL_DOWN))
        self.PinOut.append(Pin(pinout3, mode=Pin.OUT, pull=Pin.PULL_DOWN))
        #
        self.OnKeyEvent = onkeyevent
        #
        self.KeyCodes = []
        return
    #-----------------------------------------------------------------
    #   Manager
    #-----------------------------------------------------------------
    def Open(self):
        self.KeyCodes.clear()
        return 
    def Close(self):
        self.KeyCodes.clear()
        return 
    #
    def Disable(self):
        DEF.KEYBOARD4X4_ACTIVE = False
    def Enable(self):
        DEF.KEYBOARD4X4_ACTIVE = True
    #
    def GetKeyCode(self):
        if (0 < len(self.KeyCodes)):
            KC = self.KeyCodes.pop(0)
            return KC
        return 0
    #
    def Execute(self):
        KeyCode0 = 0x00
        KeyCode1 = 0x00
        KeyCode2 = 0x00
        KeyCode3 = 0x00
        #-----------------------------------------
        # Row0
        #-----------------------------------------
        self.PinOut[0].on()
        self.PinOut[1].off()
        self.PinOut[2].off()
        self.PinOut[3].off()
        CS0 = 0
        CS1 = 0
        CS2 = 0
        CS3 = 0
        for SI in range(0, self.CountRepeat):
            CS0 += self.PinIn[0].value()
            CS1 += self.PinIn[1].value()
            CS2 += self.PinIn[2].value()
            CS3 += self.PinIn[3].value()
        if (self.CountRepeat <= CS0):
            KeyCode0 = 0x11
        if (self.CountRepeat <= CS1):
            KeyCode0 = 0x21
        if (self.CountRepeat <= CS2):
            KeyCode0 = 0x41
        if (self.CountRepeat <= CS3):
            KeyCode0 = 0x81
        # if (0 < len(self.KeyCodes)):
        #     time.sleep(DEF.TIME_KEYREPETITION)
        # else:
        #     time.sleep(DEF.TIME_KEYPRESSED)
        if (0 < KeyCode0):
            self.KeyCodes.append(KeyCode0)
        #-----------------------------------------
        # Row1
        #-----------------------------------------
        self.PinOut[0].off()
        self.PinOut[1].on()
        self.PinOut[2].off()
        self.PinOut[3].off()
        CS0 = 0
        CS1 = 0
        CS2 = 0
        CS3 = 0
        for SI in range(0, self.CountRepeat):
            CS0 += self.PinIn[0].value()
            CS1 += self.PinIn[1].value()
            CS2 += self.PinIn[2].value()
            CS3 += self.PinIn[3].value()
        if (self.CountRepeat <= CS0):
            KeyCode1 = 0x12
        if (self.CountRepeat <= CS1):
            KeyCode1 = 0x22
        if (self.CountRepeat <= CS2):
            KeyCode1 = 0x42
        if (self.CountRepeat <= CS3):
            KeyCode1 = 0x82
        # if (0 < len(self.KeyCodes)):
        #     time.sleep(DEF.TIME_KEYREPETITION)
        # else:
        #     time.sleep(DEF.TIME_KEYPRESSED)
        if (0 < KeyCode1):
            self.KeyCodes.append(KeyCode1)
        #-----------------------------------------
        # Row2
        #-----------------------------------------
        self.PinOut[0].off()
        self.PinOut[1].off()
        self.PinOut[2].on()
        self.PinOut[3].off()
        CS0 = 0
        CS1 = 0
        CS2 = 0
        CS3 = 0
        for SI in range(0, self.CountRepeat):
            CS0 += self.PinIn[0].value()
            CS1 += self.PinIn[1].value()
            CS2 += self.PinIn[2].value()
            CS3 += self.PinIn[3].value()
        if (self.CountRepeat <= CS0):
            KeyCode2 = 0x14
        if (self.CountRepeat <= CS1):
            KeyCode2 = 0x24
        if (self.CountRepeat <= CS2):
            KeyCode2 = 0x44
        if (self.CountRepeat <= CS3):
            KeyCode2 = 0x84
        # if (0 < len(self.KeyCodes)):
        #     time.sleep(DEF.TIME_KEYREPETITION)
        # else:
        #     time.sleep(DEF.TIME_KEYPRESSED)
        if (0 < KeyCode2):
            self.KeyCodes.append(KeyCode2)
        #-----------------------------------------
        # Row3
        #-----------------------------------------
        self.PinOut[0].off()
        self.PinOut[1].off()
        self.PinOut[2].off()
        self.PinOut[3].on()
        CS0 = 0
        CS1 = 0
        CS2 = 0
        CS3 = 0
        for SI in range(0, self.CountRepeat):
            CS0 += self.PinIn[0].value()
            CS1 += self.PinIn[1].value()
            CS2 += self.PinIn[2].value()
            CS3 += self.PinIn[3].value()
        if (self.CountRepeat <= CS0):
            KeyCode3 = 0x18
        if (self.CountRepeat <= CS1):
            KeyCode3 = 0x28
        if (self.CountRepeat <= CS2):
            KeyCode3 = 0x48
        if (self.CountRepeat <= CS3):
            KeyCode3 = 0x88
        # if (0 < len(self.KeyCodes)):
        #     time.sleep(DEF.TIME_KEYREPETITION)
        # else:
        #     time.sleep(DEF.TIME_KEYPRESSED)
        if (0 < KeyCode3):
            self.KeyCodes.append(KeyCode3)
        #
        if (0 < len(self.KeyCodes)):
            KC = self.KeyCodes.pop(0)
            if (None != self.OnKeyEvent):
                self.OnKeyEvent(KC)
        return
#
#------------------------------------------------------------------
#   Check Library
#------------------------------------------------------------------
def Keyboard4x4_OnKeyEvent(keycode):
    print(keycode)
    return
#
if '__main__' == __name__:
    print('*** Check Keyboard4x4: begin')
    #
    Keyboard4x4 = CKeyboard4x4(DEF.PIN_KEYBOARD_IN0, DEF.PIN_KEYBOARD_IN1, 
                               DEF.PIN_KEYBOARD_IN2, DEF.PIN_KEYBOARD_IN3, 
                               DEF.PIN_KEYBOARD_OUT0, DEF.PIN_KEYBOARD_OUT1, 
                               DEF.PIN_KEYBOARD_OUT2, DEF.PIN_KEYBOARD_OUT3,
                               Keyboard4x4_OnKeyEvent)
    # Open
    Keyboard4x4.Open()
    # MainLoop ....
    for I in range(0, 10000):
        # KC = Keyboard4x4.GetKeyCode()
        # if (0 < KC):
        #     print(KC)
        #
        Keyboard4x4.Execute()
        #
        time.sleep(0.001)
    # Close
    Keyboard4x4.Close()
    #
    print('*** Check Keyboard4x4: end')
    #
#
