#
import os
import machine
import gc
from machine import Pin, SDCard
#
class CSDCard():
    #
    def __init__(self, spi='VSPI'):
        if ('VSPI' == spi):
            self.SDC = SDCard(slot=2, width=1, sck=Pin(18), miso=Pin(19), \
                              mosi=Pin(23), cs=Pin(5), freq=1000000)
        else:  
            self.SDC = SDCard(slot=2, width=1, sck=Pin(18), miso=Pin(19), \
                              mosi=Pin(23), cs=Pin(5), freq=1000000)
        self.File = None    
        return
    #
    def Open(self):        
        os.umount('/')
        os.mount(self.SDC, '/')
        return
    #
    def Close(self):
        self.CloseFile()
        os.umount('/')
        self.SDC.deinit()
        self.SDC = None
        gc.collect()
        return
    #
    def List(self, path='/'):
        return os.listdir(path)
    #
    def Delete(self, filepath):
        os.remove(filepath)
        return
    #
    def CloseFile(self):
        if (None != self.File):
           self.File.close()
           self.File = None # !!!
        return (None == self.File)
        return
    #
    def CreateWrite(self, filepath):
        self.File = open(filepath, 'w')
        return (None != self.File)
    #
    def AppendWrite(self, filepath):
        self.CloseFile()
        self.File = open(filepath, 'a')
        return (None != self.File)
    #
    def OpenRead(self, filepath):
        self.CloseFile()
        self.File = open(filepath, 'r')
        return (None != self.File)
    #
    def Write(self, text):
        if (None != self.File):
            self.File.write(text)
            return True
        return False
    #
    def WriteLine(self, text):
        if (None != self.File):
            self.File.write(text + '\r\n')
            return True
        return False
    #
    def ReadLine(self):
        Line = ''
        if (None != self.File):
            Line = self.File.readline()
        return Line
    #



#