#
import time as TIM
from machine import UART
#
import Define as DEF
import Lines as LIN
import Thread as THR
#
class CUart():
    #---------------------------------------------------------
    #   Constructor
    #---------------------------------------------------------
    def __init__(self, uartid, txpin, rxpin, ontxline, onrxline):
        self.Uart = UART(uartid, tx=txpin, rx=rxpin)
        self.OnTxLine = ontxline
        self.OnRxLine = onrxline
        self.TxLines = LIN.CLines()
        self.RxLines = LIN.CLines() 
        self.RxLine = ''
        self.Thread = THR.CThread(self.CBOnStart, self.CBOnBusy, self.CBOnAbort, self.CBOnEnd)
    #---------------------------------------------------------
    #   Property
    #---------------------------------------------------------
    def IsBusy(self):
        return THR.stBusy == self.Thread.State
    #---------------------------------------------------------
    #   Callback Thread
    #---------------------------------------------------------
    def CBOnStart(self, thread):
        self.TxLines.Clear()
        self.RxLines.Clear()
        return
    def CBOnBusy(self, thread):
        while (THR.stBusy == thread.State):
            # zero: RxData - convert/collect rxline
            while (0 < self.Uart.any()):
                C = self.Uart.read(1)
                if (None != C):
                    if (b'\r' == C) or (b'\n' == C):
                        if (0 < len(self.RxLine)):
                            self.RxLines.Push(self.RxLine)
                            self.RxLine = '';
                    else:
                        self.RxLine += C.decode("utf-8")
            # NO sleep!!! TIM.sleep(0.01)
            # first: RxData - callback
            if (0 < self.RxLines.Count()):
               if (None != self.OnRxLine):
                    RxLine = self.RxLines.Pop()
                    self.OnRxLine(RxLine)
            # NO sleep!!! TIM.sleep(0.01)
            # second: TxData - send / callback
            if (0 < self.TxLines.Count()):
                if (None != self.OnTxLine):
                    TxLine = self.TxLines.Pop()                                    
                    TxLine = self.OnTxLine(TxLine)
                    self.Uart.write(TxLine + '\r\n')
            # NO sleep!!! TIM.sleep(0.01)
        return
    def CBOnAbort(self, thread):
        self.TxLines.Clear()
        self.RxLines.Clear()
        return
    def CBOnEnd(self, thread):
        self.TxLines.Clear()
        self.RxLines.Clear()
        return
    #---------------------------------------------------------
    #   Handler
    #---------------------------------------------------------
    def Open(self):
        self.Uart.init(baudrate=115200)#, bits=8, parity=None, stop=1, cts=-1, rts=-1)
        self.Thread.Start()   
        self.RxLine = ''
        return
    #
    def Close(self):
        self.Thread.Abort()
        self.Uart.deinit()
        return 
    #
    def TxLine(self, txline):
        self.TxLines.Push(txline)
    #
    def RxLine(self):
        return self.RxLines.Pop()
    #
#
#-------------------------------------------------------------
#   Uart - Main - Check Library
#-------------------------------------------------------------
def Uart_OnTxLine(txline):
    print('OnTxLine[{}]'.format(txline))
    return txline # !!!!!! In this CB return TxLine-Value !!!!
#    
def Uart_OnRxLine(rxline):
    print('OnRxLine[{}]'.format(rxline))
    return
#
if ('__main__' == __name__):    
    print('*** CheckUart: begin')
    #
    Uart = CUart(DEF.ID_UART1, 
                 DEF.PIN_UART1_TX, DEF.PIN_UART1_RX, 
                 Uart_OnTxLine, Uart_OnRxLine)
    Uart.Open()
    #
    Uart.TxLine('000asdf')
    Uart.TxLine('111asdf')
    TIM.sleep(2.0)
    Uart.TxLine('222asdf')
    Uart.TxLine('333asdf')
    TIM.sleep(2.0)
    Uart.TxLine('444asdf')
    Uart.TxLine('555asdf')
    TIM.sleep(2.0)
    #
    Uart.Close()
    #
    print('*** CheckUart: end')
#    