#
import time
import socket as SKT
import network as NTW
#
import Define as DEF
import Lines as LIN
#
class CWlanUdp():
    #---------------------------------------------------------
    #   Constructor
    #---------------------------------------------------------
    def __init__(self, wlanssid, wlanpw, headerid, ipportrx, \
                 ipaddresstx, ipporttx, ontxline, onrxline):   
        self.WlanSSID = wlanssid
        self.WlanPW = wlanpw            
        self.HeaderID = headerid
        self.IPAddressRXLocal = ''
        self.IPPortRX = ipportrx
        self.IPAddressTX = ipaddresstx
        self.IPPortTX = ipporttx
        self.Wlan = None
        self.RxSocket = None
        self.TxSocket = None
        #
        self.RxLines = LIN.CLines()
        self.TxLines = LIN.CLines()
        self.OnTxLine = ontxline
        self.OnRxLine = onrxline
        self.RxLine = ''
        #
        return
    #---------------------------------------------------------
    #   Property
    #---------------------------------------------------------
    def GetHeaderID(self):
        return self.HeaderID
    def GetIPAddressTX(self):
        return self.IPAddressTX
    def GetIPPortTX(self):
        return self.IPPortTX
    def GetIPAddressRXLocal(self):
        return self.IPAddressRXLocal
    def GetIPPortRX(self):
        return self.IPPortRX
    #---------------------------------------------------------
    #   Handler
    #---------------------------------------------------------
    def Open(self):
        self.Wlan = NTW.WLAN(NTW.STA_IF)
        self.Wlan.active(False)
        self.Wlan.active(True)
        self.Wlan.connect(self.WlanSSID, self.WlanPW)
        while not(self.Wlan.isconnected()):
            pass
        self.IPAddressRXLocal = self.Wlan.ifconfig()[0]
        if DEF.DEBUG_WLANUDP:
            print('Wlan-IDs[{}]'.format(self.Wlan.ifconfig()))
            print('Wlan-LocalIPAddress[{}]'.format(self.IPAddressRXLocal))
        # Rx
        self.RxSocket = SKT.socket(SKT.AF_INET, SKT.SOCK_DGRAM)
        # FORWARD Socket.bind !!!
        self.RxSocket.setsockopt(SKT.SOL_SOCKET, SKT.SO_REUSEADDR, 1)
        self.RxSocket.bind((self.IPAddressRXLocal, self.IPPortRX))
        self.RxSocket.setblocking(0)
        # Tx
        self.TxSocket = SKT.socket(SKT.AF_INET, SKT.SOCK_DGRAM)
        self.TxSocket.connect((self.IPAddressTX, self.IPPortTX))
        #
        # if DEF.DEBUG_WLANUDP:
        print('{}: TxIP-Address[{}]-Port[{}]'.format(self.GetHeaderID(), 
                                                    self.GetIPAddressTX(), 
                                                    self.GetIPPortTX()))
        print('{}: RxIP-Address[{}]-Port[{}](local)'.format(self.GetHeaderID(), 
                                                            self.GetIPAddressRXLocal(),
                                                            self.GetIPPortRX()))
        return   
    #
    def Close(self):
        if DEF.DEBUG_WLANUDP:
            print('UdpClientServer.Close')
        self.RxSocket.close()
        self.TxSocket.close()
    #
    def Abort(self):
        self.RxSocket.close()
        self.TxSocket.close()
        return
    #
    def TxLine(self, txline):
        self.TxLines.Push(txline)
    #
    def RxLine(self):
        return self.RxLines.Pop()
    #
    def Execute(self):
        self.RxLine = ''       
        try:
            # zero: RxData - convert/collect rxline
            RxBuffer, Address = self.RxSocket.recvfrom(1024)
            RxSize = len(RxBuffer)
            RxText = RxBuffer.decode()
            for CI in range(0, RxSize):
                AC = RxText[CI]
                if (('\r' == AC) or ('\n' == AC)):
                    if (0 < len(self.RxLine)):
                        self.RxLines.Push(self.RxLine)
                    self.RxLine = ''
                else:
                    self.RxLine += AC
            # first: RxData - callback
            if (0 < self.RxLines.Count()):
                if (None != self.OnRxLine):
                    Line = self.RxLines.Pop()
                    self.OnRxLine(Line)
            # second: TxData - send / callback
            if (0 < self.TxLines.Count()):
                if (None != self.OnTxLine):
                    Line = self.TxLines.Pop()                                    
                    Line = self.OnTxLine(Line) 
                    self.TxSocket.sendto(Line.encode('utf-8'), \
                                        (self.IPAddressTX, self.IPPortTX))
        except:
            pass 
        # finally:
        #     time.sleep(0.05)
        return    
    #
#