#
import os
import machine
#
import Lines as LIN
#
class CDispatcher():
    #
    def __init__(self, onexecutecommand, onexecuteevent):
        self.Commands = LIN.CLines()
        self.OnExecuteCommand = onexecutecommand
        self.Events = LIN.CLines()
        self.OnExecuteEvent = onexecuteevent
        return
   #-------------------------------------------------
    #   Property
    #-------------------------------------------------
    def CountCommands(self):
        return len(self.Commands)
    def CountEvents(self):
        return len(self.Events)
    #-------------------------------------------------
    #   Handler
    #-------------------------------------------------
    def Open(self):
        self.Commands.Clear()
        self.Events.Clear()
        return
    #
    def Close(self):
        self.Commands.Clear()
        self.Events.Clear()
        return
    #
    def ClearCommands(self):
        self.Commands.Clear()
        return
    def ClearEvents(self):
        self.Events.Clear()
        return
    # Push: object to end of fifo
    def PushCommand(self, command):
        self.Commands.Push(command)
        return
    def PushEvent(self, event):
        self.Events.Push(event)
        return
    # Pop: object from start of fifo
    def PopCommand(self):
        return self.Commands.Pop()
    def PopEvent(self):
        return self.Events.Pop()
    #
    def ExecuteCommand(self):
        if (0 < self.Commands.Count()):
            Command = self.Commands.Pop()
            if (0 < len(Command)): 
                if (None != self.OnExecuteCommand):
                    self.OnExecuteCommand(Command)
        return
    #
    def ExecuteEvent(self):
        if (0 < self.Events.Count()):
            Event = self.Events.Pop()
            if (0 < len(Event)):                
                if (None != self.OnExecuteEvent):
                    self.OnExecuteEvent(Event)
        return
    #
    def RunPythonScript(self, filename):
        print('RunScript[{}]-begin'.format(filename))
        exec(open(filename).read(), globals(), locals())
        print('RunScript[{}]-end'.format(filename))
        return
    #
    def AbortProgramReset(self): # RESET ! (only at end of program!!!)
        machine.reset() 
        return
    #
#