#
import machine
import time as TIM
import bluetooth as BLU
#
import Define as DEF
#
if DEF.UARTPC_ACTIVE or DEF.UARTUC_ACTIVE:
    import Uart as UAR
if DEF.BTUARTAD_ACTIVE:
    import BtUart as BTU
if DEF.WLANUDPPC_ACTIVE:
    import WlanUdp as WLU
#
if DEF.LEDSYSTEM_ACTIVE:
    import LedSystem as LS
if DEF.LEDSYSTEM_ACTIVE:
    import LCDisplayI2C as LCD
if DEF.KEYBOARD4X4_ACTIVE:
    import Keyboard4x4 as KBD
if DEF.SDCARD_ACTIVE:
    import SDCard as SDC
if DEF.DISPATCHER_ACTIVE:
    import Dispatcher as DIS
#   
#-----------------------------------------------------------
#   Main - Callback
#-----------------------------------------------------------
# Callback - UartPC
def UartPC_OnRxLine(rxline):
    # if DEF.DEBUG_UART2:
    #     print('UartPC_OnRxLine[{}]'.format(rxline))
    if DEF.DISPATCHER_ACTIVE:
        Dispatcher.PushCommand(rxline)
    return
def UartPC_OnTxLine(txline):
    # if DEF.DEBUG_UART2:
    #     print('UartPC_OnTxLine[{}]'.format(txline))
    return txline # !!! NECESSARY !!!
#
# Callback - UartUC
def UartUC_OnRxLine(rxline):
    # if DEF.DEBUG_UART1:
    #     print('UartUC_OnRxLine[{}]'.format(rxline))
    if DEF.DISPATCHER_ACTIVE:
        Dispatcher.PushCommand(rxline)
    return
def UartUC_OnTxLine(txline):
    # if DEF.DEBUG_UART1:
    #     print('UartUC_OnTxLine[{}]'.format(txline))
    return txline # !!! NECESSARY !!!
#
# Callback - BtUartAD
def BtUartAD_OnRxLine(rxline):
    # if DEF.DEBUG_BTUART:
    #     print('BtUartAD_OnRxLine[{}]'.format(rxline))
    if DEF.DISPATCHER_ACTIVE:
        Dispatcher.PushCommand(rxline)
    return
def BtUartAD_OnTxLine(txline):
    # if DEF.DEBUG_BTUART:    
    #     print('BtUartAD_OnTxLine[{}]'.format(txline))
    return txline # !!! NECESSARY !!!

# Callback - WlanUdpPC
def WlanUdpPC_OnRxLine(rxline):
    # if DEF.DEBUG_WLANUDP:
    #     print('WlanUdpPC_OnRxLine[{}]'.format(rxline))
    if DEF.DISPATCHER_ACTIVE:
        Dispatcher.PushCommand(rxline)
    return
def WlanUdpPC_OnTxLine(txline):
    # if DEF.DEBUG_WLANUDP:
    #     print('WlanUdpPC_OnTxLine[{}]'.format(txline))
    return txline # !!! NECESSARY !!!
#
# Callback - LedSystem
def LedSystem_OnEvent(state):
    # if DEF.DEBUG_LEDSYSTEM:
    #     print('LedSystem_OnEvent[{}]'.format(state))
    if DEF.DISPATCHER_ACTIVE:
        Dispatcher.PushEvent('!SLS {}'.format(state))
    return
#
# Callback - Keyboard
def Keyboard4x4_OnKeyEvent(keycode):
    if DEF.KEYBOARD4X4_ACTIVE:
        # if DEF.DEBUG_KEYBOARD4X4:
        #     print('Keyboard4x4_OnKeyEvent[{}]'.format(keycode))
        if DEF.DISPATCHER_ACTIVE:
            Dispatcher.PushEvent('!EKC {}'.format(keycode))
    return    
#
def Dispatcher_OnExecuteCommand(command):
    # if DEF.DEBUG_DISPATCHER:
    #     print('Dispatcher_OnExecuteCommand[{}]'.format(command))
    Tokens = command.split(' ')
    if (None != Tokens):
        TC = len(Tokens)
        if DEF.LCDISPLAYI2C_ACTIVE:
            LCDisplayI2C.Write(3, 0, '                    ')
            LCDisplayI2C.Write(3, 0, command)
        if (1 == TC): # C 
            if ('@LSO' == Tokens[0]):
                if DEF.LEDSYSTEM_ACTIVE:
                    LedSystem.SetOn()
                return    
            if ('@LSF' == Tokens[0]):
                if DEF.LEDSYSTEM_ACTIVE:
                    LedSystem.SetOff()
                return    
            if ('@APR' == Tokens[0]):
                if DEF.DISPATCHER_ACTIVE:
                    Dispatcher.AbortProgramReset()
                return    
            if ('@DKB' == Tokens[0]):
                if DEF.KEYBOARD4X4_ACTIVE:
                    Keyboard4x4.Disable()
                return    
            if ('@EKB' == Tokens[0]):
                if DEF.KEYBOARD4X4_ACTIVE:
                    Keyboard4x4.Enable()
                return    
            if ('@CLD' == Tokens[0]):
                if DEF.LCDISPLAYI2C_ACTIVE:
                    LCDisplayI2C.Clear()
                return    
            if ('@SDO' == Tokens[0]):
                if DEF.LCDISPLAYI2C_ACTIVE:
                    LCDisplayI2C.DisplayOn()
                return    
            if ('@SDF' == Tokens[0]):
                if DEF.LCDISPLAYI2C_ACTIVE:
                    LCDisplayI2C.DisplayOff()            
                return    
            if ('@SBO' == Tokens[0]):
                if DEF.LCDISPLAYI2C_ACTIVE:
                    LCDisplayI2C.BacklightOn()
                return    
            if ('@SBF' == Tokens[0]):
                if DEF.LCDISPLAYI2C_ACTIVE:
                    LCDisplayI2C.BacklightOff()
                return    
            # error: Invalid Command!
            return
        if (2 == TC): # C P0 
            if ('@XPS' == Tokens[0]):                
                print('RunScript[{}]-begin'.format(Tokens[1]))
                exec(open(Tokens[1]).read())#, globals(), locals())
                print('RunScript[{}]-end'.format(Tokens[1]))
                #--------------------
                # OK exec(open('blinky.py').read())#, globals(), locals())
                # OK return    
                #--------------------
                # Dispatcher.RunPythonScript(Tokens[1])
                #
                #exec(open(Tokens[1]).read()) # globals(), locals())
                #print('RunScript[{}]-begin'.format(Tokens[1]))
                #exec(open('demo.py').read(), globals(), locals())
                #print('RunScript[{}]-end'.format(Tokens[1]))
            # error: Invalid Command!
                # OK:
                # print('RunScript[{}]-begin'.format(Tokens[1]))
                # exec('print(\'Hello World!\')')
                # print('RunScript[{}]-end'.format(Tokens[1]))
            return
        if (4 == TC): # C P0 P1 P2
            if ('@WDT' == Tokens[0]):
                R = int(Tokens[1])
                C = int(Tokens[2])
                LCDisplayI2C.Write(R, C, Tokens[3])
                return    
            # error: Invalid Command!
            return
        # error: Invalid Command!
        return
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if DEF.SDCARD_ACTIVE:
            try:
                if DEF.SDCARD_ACTIVE:
                    SDCard.AppendWrite(DEF.FILENAME_SYSTEMPROTOCOL)
                    SDCard.WriteLine(command)
            except:
                print('OSError: Can not append to File!')
            finally:
                if DEF.SDCARD_ACTIVE:
                    SDCard.CloseFile()
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    return
def Dispatcher_OnExecuteEvent(event):
    if DEF.DEBUG_DISPATCHER:
        print('Dispatcher_OnExecuteEvent[{}]'.format(event))
    if DEF.UARTPC_ACTIVE:
        UartPC.TxLine(event)
    if DEF.UARTUC_ACTIVE:
        UartUC.TxLine(event)
    if DEF.BTUARTAD_ACTIVE:
        BtUartAD.TxLine(event)
    if DEF.WLANUDPPC_ACTIVE:
        WlanUdpPC.TxLine(event)
    if DEF.LCDISPLAYI2C_ACTIVE:
        LCDisplayI2C.Write(3, 0, '                    ')
        LCDisplayI2C.Write(3, 0, event)
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if DEF.SDCARD_ACTIVE:
            try:
                SDCard.AppendWrite(DEF.FILENAME_SYSTEMPROTOCOL)
                SDCard.WriteLine(event)
            except:
                print('OSError: Can not append to File!')
            finally:
                SDCard.CloseFile()
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    return
#
if ('__main__' == __name__):
# try:
    MillisStart = TIM.ticks_ms()
    MillisSystem = MillisStart
    #
    print('*** Esp32ScriptingCommandDispatcher: begin')
    #----------------------------------------------------------
    # Local Ressource : SDCard
    #----------------------------------------------------------
    if DEF.SDCARD_ACTIVE:
        SDCard = SDC.CSDCard()
        SDCard.Open()
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        try:
            SDCard.Delete(DEF.FILENAME_SYSTEMPROTOCOL)
        except:
            print('OSError: Protocol-File does not exist!')
        try:
            SDCard.CreateWrite(DEF.FILENAME_SYSTEMPROTOCOL)
            L = '#0 ProtocolFile'
            SDCard.WriteLine(L)
            print(L)
        except:
            print('OSError: Can not write to Protocol-File!')
        finally:
            SDCard.CloseFile() # !!! File !!!
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    #----------------------------------------------------------
    # Local Ressource : Uart-PC
    #----------------------------------------------------------
    if DEF.UARTPC_ACTIVE:
        UartPC = UAR.CUart(DEF.ID_UART2, DEF.PIN_UART2_TX, DEF.PIN_UART2_RX,
                           UartPC_OnTxLine, UartPC_OnRxLine)
    #----------------------------------------------------------
    # Child Ressource : UartUC
    #----------------------------------------------------------    
    if DEF.UARTUC_ACTIVE:
        UartUC = UAR.CUart(DEF.ID_UART1, DEF.PIN_UART1_TX, DEF.PIN_UART1_RX,
                           UartUC_OnTxLine, UartUC_OnRxLine)
    #----------------------------------------------------------
    # Local Ressource : Bt-AndroidDevice
    #----------------------------------------------------------
    if DEF.BTUARTAD_ACTIVE:
        BLE = BLU.BLE()
        BtUartAD = BTU.CBtUart(BLE, BtUartAD_OnTxLine, BtUartAD_OnRxLine, 
                               "Esp32BtUart", rxbuffersize=100)
    #----------------------------------------------------------
    # Local Ressource : Wlan-Udp-PC
    #----------------------------------------------------------
    if DEF.WLANUDPPC_ACTIVE:
        WlanUdpPC = WLU.CWlanUdp(DEF.WLAN_SSID, DEF.WLAN_PW,
                                 DEF.UDP_HEADERID, DEF.UDP_IPPORT_RX,
                                 DEF.UDP_IPADDRESS_TX, DEF.UDP_IPPORT_TX, 
                                 WlanUdpPC_OnTxLine, WlanUdpPC_OnRxLine)                             
    #----------------------------------------------------------
    # Local Ressource - LedSystem                         
    #----------------------------------------------------------    
    if DEF.LEDSYSTEM_ACTIVE:
        LedSystem = LS.CLedSystem(DEF.PIN_LEDSYSTEM, LedSystem_OnEvent)
    #----------------------------------------------------------    
    # Local Ressource : LCDisplayI2C
    #----------------------------------------------------------    
    if DEF.LCDISPLAYI2C_ACTIVE:
        I2CDisplay = machine.SoftI2C(scl=machine.Pin(22), sda=machine.Pin(21), freq=2000000)  
        LCDisplayI2C = LCD.CLCDisplayI2C(I2CDisplay, DEF.I2CADDRESS_LCDISPLAY_T, \
                                         DEF.LCDISPLAY_COUNT_ROWS, DEF.LCDISPLAY_COUNT_COLUMNS)    
    #----------------------------------------------------------    
    # Local Ressource : Keyboard
    #----------------------------------------------------------    
    if DEF.KEYBOARD4X4_ACTIVE:
        Keyboard4x4 = KBD.CKeyboard4x4(DEF.PIN_KEYBOARD_IN0, DEF.PIN_KEYBOARD_IN1, 
                                       DEF.PIN_KEYBOARD_IN2, DEF.PIN_KEYBOARD_IN3, 
                                       DEF.PIN_KEYBOARD_OUT0, DEF.PIN_KEYBOARD_OUT1, 
                                       DEF.PIN_KEYBOARD_OUT2, DEF.PIN_KEYBOARD_OUT3,
                                       Keyboard4x4_OnKeyEvent)        
    #----------------------------------------------------------    
    # Dispatcher
    #----------------------------------------------------------    
    if DEF.DISPATCHER_ACTIVE:
        Dispatcher = DIS.CDispatcher(Dispatcher_OnExecuteCommand, Dispatcher_OnExecuteEvent)
    #
    # Open LocalRessources
    if DEF.LCDISPLAYI2C_ACTIVE:
        LCDisplayI2C.Open()
        LCDisplayI2C.Write(0, 0, '*** Esp32 - SCD ****')
        LCDisplayI2C.Write(2, 0, '[01V09]-[2201191718]')
        LCDisplayI2C.Write(1, 0, 'BETA !!! CommandDisp')
        LCDisplayI2C.Write(3, 0, '.OpenHardSoftWare.de')
    if DEF.KEYBOARD4X4_ACTIVE:
        Keyboard4x4.Open()
    if DEF.LEDSYSTEM_ACTIVE:
        LedSystem.Open(0) #3)
    if DEF.DISPATCHER_ACTIVE:
        Dispatcher.Open()
    #
    # Open InterfaceCommunication
    if DEF.UARTPC_ACTIVE:
        UartPC.Open()
    if DEF.UARTUC_ACTIVE:
        UartUC.Open()
    if DEF.BTUARTAD_ACTIVE:
        BtUartAD.Open()
    if DEF.WLANUDPPC_ACTIVE:
        WlanUdpPC.Open()
    #
    MainLoop = True
    while (MainLoop):
        if DEF.BTUARTAD_ACTIVE:
            BtUartAD.Execute()
        if DEF.WLANUDPPC_ACTIVE:
            WlanUdpPC.Execute()
        if DEF.KEYBOARD4X4_ACTIVE:
            Keyboard4x4.Execute()
        if DEF.DISPATCHER_ACTIVE:
            Dispatcher.ExecuteCommand()
            Dispatcher.ExecuteEvent()
        #
        MillisNow = TIM.ticks_ms()
        if (2000 < (MillisNow - MillisSystem)):
            MillisSystem = MillisNow
            #
            LT = MillisNow
            LL = int(LT % 1000)
            #
            ST = int(LT / 1000)
            SS = int(ST % 60)
            #
            MT = int(ST / 60)
            MM = int(MT % 60)
            #
            HT = int(MT / 60)
            HH = int(HT % 60)
            #
            Dispatcher.PushEvent('!EST %02d:%02d:%02d.%03d' %  (HH, MM, SS, LL))
            # OK !!! exec('print(\'Hello World!\')', globals(), locals())
            # OK !!! exec(open('blinky.py').read())
            #
        if (120000 <= (MillisNow - MillisStart)): 
            MainLoop = False
    #
    if DEF.DISPATCHER_ACTIVE:
        Dispatcher.Close()
    if DEF.LEDSYSTEM_ACTIVE:
        LedSystem.Close()
    if DEF.LCDISPLAYI2C_ACTIVE:
        LCDisplayI2C.Close()
    if DEF.KEYBOARD4X4_ACTIVE:
        Keyboard4x4.Close()

    if DEF.WLANUDP_ACTIVE:
        WlanUdpPC.Close()
    if DEF.BTUART_ACTIVE:
        BtUartAD.Close()
    if DEF.UARTUC_ACTIVE:
        UartUC.Close()
    if DEF.UARTPC_ACTIVE:
        UartPC.Close()
    if DEF.SDCARD_ACTIVE:
        SDCard.CloseFile()
    #
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    if DEF.SDCARD_ACTIVE:
        try:
            SDCard.OpenRead(DEF.FILENAME_SYSTEMPROTOCOL)
            EOF = False
            while not(EOF):
                L = SDCard.ReadLine()
                if (0 < len(L)):
                    print(L, end='')
                else:
                    EOF = True
        except:
            print('OSError: Can not read from File!')
        finally:
            SDCard.CloseFile()
            print(SDCard.List())
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    #  
# except:
#     print('ERROR!')
# finally:
    if DEF.SDCARD_ACTIVE:
        SDCard.Close()
    print('*** Esp32ScriptingCommandDispatcher: end')
    #
    if DEF.DISPATCHER_ACTIVE:
        Dispatcher.AbortProgramReset()
    #
#

