#
from machine import Pin
import time as TIM
#
class CLedSystem():
    #
    def __init__(self, pinindex, onevent):
        self.Pin = Pin(pinindex)
        self.OnEvent = onevent
        return
    #
    def Open(self, count=0):
        self.Pin.init(mode=Pin.OUT)
        self.Pin.off()
        for IB in range(0, count):
            self.SetOn()
            TIM.sleep(0.05)
            self.SetOff()
            TIM.sleep(0.1)
    #
    def Close(self):
        self.Pin.off()
        self.Pin.init(mode=Pin.IN)
    #
    def SetOn(self):
        self.Pin.on()
        if (None != self.OnEvent):
            self.OnEvent('1')
    #
    def SetOff(self):
        self.Pin.off()
        if (None != self.OnEvent):
            self.OnEvent('0')
#