#
############################################################
#   System - DEBUG
############################################################
# DEBUG_SYSTEM        = False
# NC !!!! DEBUG_UART0  = False
DEBUG_UART1         = False # UartUC
DEBUG_UART2         = False # UartPC
DEBUG_BTUART        = False # BtUartAD
DEBUG_WLANUDP       = False # WlanUdpPC
DEBUG_LEDSYSTEM     = False
DEBUG_LCDISPLAYI2C  = False
DEBUG_KEYBOARD4X4   = False
DEBUG_SDCARD        = False
DEBUG_DISPATCHER    = False
#
############################################################
#   System - Hardware
############################################################
UARTPC_ACTIVE       = True
UARTUC_ACTIVE       = True
BTUARTAD_ACTIVE     = True
WLANUDPPC_ACTIVE    = True
LANUDPPC_ACTIVE     = False # NOT in MicroPython available!
LEDSYSTEM_ACTIVE    = True
LCDISPLAYI2C_ACTIVE = True
KEYBOARD4X4_ACTIVE  = True
SDCARD_ACTIVE       = False # True
DISPATCHER_ACTIVE   = True
#
############################################################
#   Uart
############################################################
#-----------------------------------------
#   Uart0
#-----------------------------------------
ID_UART0     =  0 # Uart-Debug/Program-Interface Esp32-PC
PIN_UART0_TX =  1 # USB
PIN_UART0_RX =  3 # USB
#-----------------------------------------
#   Uart1
#-----------------------------------------
ID_UART1     =  1 # Uart-Command/Response-Interface Esp32-Stm32
PIN_UART1_RX = 25 #  9 - not usable 
PIN_UART1_TX = 26 # 10 - not usable 
#-----------------------------------------
#   Uart2
#-----------------------------------------
ID_UART2     =  2 # Uart-Command/Response-Interface Esp32-PC
PIN_UART2_RX = 16
PIN_UART2_TX = 17
#
############################################################
#   Bluetooth - Uart
############################################################
#
############################################################
#   Wlan - Udp
############################################################
WLAN_SSID           = 'FritzBoxSA7'
WLAN_PW             = '01234567890123456789'
#
UDP_HEADERID        = 'UDPHID'
#-----------------------------------------------------------
#   UDP - TxD - TransmitData
#-----------------------------------------------------------
UDP_IPADDRESS_TX    = '192.168.178.33' 
UDP_IPPORT_TX       = 5000
#
#-----------------------------------------------------------
#   UDP - RxD - ReceiveData
#-----------------------------------------------------------
UDP_IPADDRESS_LOCAL = '192.168.178.71' # dummy, overwritten
UDP_IPPORT_RX       = 5001
#
############################################################
#   SDCard
############################################################
FILENAME_SYSTEMPROTOCOL = '/protocol.txt'
#
############################################################
#   LedSystem
############################################################
PIN_LEDSYSTEM = 2
#
############################################################
#   LCDisplayI2C
############################################################
I2CADDRESS_LCDISPLAY_T  = 0x27
I2CADDRESS_LCDISPLAY_A  = 0x3F
#
LCDISPLAY_COUNT_ROWS    = 4
LCDISPLAY_COUNT_COLUMNS = 20
#
############################################################
#   Keyboard4x4
############################################################
PIN_KEYBOARD_IN0 = 39
PIN_KEYBOARD_IN1 = 36
PIN_KEYBOARD_IN2 = 34
PIN_KEYBOARD_IN3 = 35
PIN_KEYBOARD_OUT0 = 13
PIN_KEYBOARD_OUT1 = 12
PIN_KEYBOARD_OUT2 = 14
PIN_KEYBOARD_OUT3 = 27
#
SIZE_KEYCODEBUFFER = 5
TIME_KEYPRESSED = 0.110
TIME_KEYREPETITION = 0.500
#
############################################################
#   Dispatcher
############################################################
#