#
# Syntax-Arguments: <headerid> <rxipport> <txipaddress> <txipport>
#
# WindowsPC[192.168.178.33] <-> # WindowsPC[192.168.178.33]:
# WinPC: python CheckUdpClientServer.py Windows 4321 192.168.178.33 4321


# WindowsPC[192.168.178.33] <-> UbuntuPC[192.168.178.48]
# WinPC: python CheckUdpClientServer.py Windows 5001 192.168.178.48 5000
# LinPC: python CheckUdpClientServer.py Ubuntu  5000 192.168.178.33 5001 
#
import sys
import time
import socket as SKT
#
import Thread as THR
import WlanUdp as WLU
#
UDP_HEADERID = 'UDPHID'
#-----------------------------------------------------------
#   UDP - TxD - TransmitData
#-----------------------------------------------------------
UDP_IPADDRESS_TX = '192.168.178.71' #'255'
UDP_IPPORT_TX = 5001
#
#-----------------------------------------------------------
#   UDP - RxD - ReceiveData
#-----------------------------------------------------------
UDP_IPADDRESS_LOCAL = '192.168.178.33' # dummy
UDP_IPPORT_RX = 5000
#   
#-----------------------------------------------------------
#   Callback - UdpClient
#-----------------------------------------------------------
def CBOnTxData(udpclientserver, txdata):
    Line = 'CBOnTxData[{}]<{}>'.format(udpclientserver.GetHeaderID(), txdata)
    print(Line)
    return
#
def CBOnRxData(udpclientserver, rxdata):
    Line = 'CBOnRxData[{}]<{}>'.format(udpclientserver.GetHeaderID(), rxdata)
    print(Line)
    return
#
def CBOnStart(udpclientserver):
    # debug print('Main-CBOnStart')
    return
#
def CBOnBusy(udpclientserver):
    # debug print('Main-CBOnBusy')
    return
#
def CBOnAbort(udpclientserver):
    # debug print('Main-CBOnAbort')
    return
#
def CBOnEnd(udpclientserver):
    # debug print('Main-CBOnEnd')
    return
#   
#-----------------------------------------------------------
#   Main
#-----------------------------------------------------------
if ('__main__' == __name__):
    #
    print('*** PcWlanUdpTxRxLine: begin')
    # if (5 <= len(sys.argv)):
    #     # Analyse Arguments für Tx/Rx-Parameter
    #     UDP_HEADERID = sys.argv[1]
    #     # RX
    #     UDP_IPPORT_RX = int(sys.argv[2])
    #     # TX
    #     UDP_IPADDRESS_TX = sys.argv[3]
    #     UDP_IPPORT_TX = int(sys.argv[4])
    #
    UdpCS = WLU.CWlanUdp(UDP_HEADERID, UDP_IPPORT_RX,
                         UDP_IPADDRESS_TX, UDP_IPPORT_TX, 
                         CBOnTxData, CBOnRxData, 
                         CBOnStart, CBOnBusy, CBOnAbort, CBOnEnd)
    #        
    print('{}: TxIP-Address[{}]-Port[{}]'.format(UdpCS.GetHeaderID(), 
                                                 UdpCS.GetIPAddressTX(), 
                                                 UdpCS.GetIPPortTX()))
    print('{}: RxIP(local)-Address[{}]-Port[{}]'.format(UdpCS.GetHeaderID(), 
                                                 UdpCS.GetIPAddressRXLocal(),
                                                 UdpCS.GetIPPortRX()))
    UdpCS.Open()
    time.sleep(1.0)
    #
    # UdpCS.Transmit('@DKB\r\n')
    # UdpCS.Transmit('@SDO\r\n')
    # UdpCS.Transmit('@CLD\r\n')
    # UdpCS.Transmit('@SBO\r\n')
    # time.sleep(2.0)
    # UdpCS.Transmit('@WDT 1 1 Hello\r\n')    
    # #
    # for IB in range(0, 10):
    #     UdpCS.Transmit('@LSF\r\n')
    #     time.sleep(1.0)
    #     UdpCS.Transmit('@LSO\r\n')
    #     time.sleep(1.0)
    # #
    # UdpCS.Transmit('@EKB\r\n')
    # time.sleep(10.0)    
    # UdpCS.Transmit('@CLD\r\n')
    # time.sleep(2.0)    
    # UdpCS.Transmit('@SDF\r\n')
    # time.sleep(2.0)    
    # UdpCS.Transmit('@SBF\r\n')
    # time.sleep(2.0)    
    # UdpCS.Transmit('@APR\r\n')
    #
    for ITE in range(0, 10):
         UdpCS.Transmit('@XPS hellolfs.py\r\n')
         time.sleep(0.10)
    #
    # for ITE in range(0, 2):
    #     UdpCS.Transmit('@XPS ./blinky.py\r\n')
    #     time.sleep(2.0)
    #
    # for ITE in range(0, 2):
    #     UdpCS.Transmit('@XPS /hello.py\r\n')
    #     time.sleep(2.0)
    # #
    # for ITE in range(0, 2):
    #     UdpCS.Transmit('@XPS /quick.py\r\n')
    #     time.sleep(2.0)
    #
    UdpCS.Transmit('@APR\r\n')
    #
    UdpCS.Close()
    print('*** PcWlanUdpTxRxLine: end')
    #
#


