"""Implements a HD44780 character LCD connected via PCF8574 on I2C.
   This was tested with: https://www.wemos.cc/product/d1-mini.html"""

from time import sleep_ms, ticks_ms
from machine import I2C, Pin
from esp8266_i2c_lcd import I2cLcd

# The PCF8574 has a jumper selectable address: 0x20 - 0x27
DEFAULT_I2C_ADDR = 0x27
# DEFAULT_I2C_ADDR = 0x3F

def test_main():
    """Test function for verifying basic functionality."""
    print("Running test_main")
    i2c = I2C(scl=Pin(22), sda=Pin(21), freq=100000) # scl=Pin(5), sda=Pin(4), freq=100000)
    lcd = I2cLcd(i2c, DEFAULT_I2C_ADDR, 4, 20)
    lcd.putstr("time:\nSecond Line")
    sleep_ms(3000)
    lcd.clear()
    count = 0
    while True:
        lcd.move_to(1, 0)
        lcd.putstr("Line 1")
        lcd.move_to(2, 0)
        lcd.putstr("Line 2")
        lcd.move_to(3, 0)
        lcd.putstr("Line 3")
        lcd.move_to(0, 0)
        lcd.putstr("time[%5d]" % (ticks_ms() // 1000))
        #sleep_ms(1000)
        # count += 1
        # if count % 10 == 3:
        #     print("Turning backlight off")
        #     #lcd.backlight_off()
        # if count % 10 == 4:
        #     print("Turning backlight on")
        #     lcd.backlight_on()
        # if count % 10 == 5:
        #     print("Turning display off")
        #     #lcd.display_off()
        # if count % 10 == 6:
        #     print("Turning display on")
        #     lcd.display_on()
        # if count % 10 == 7:
        #     print("Turning display & backlight off")
        #     #lcd.backlight_off()
        #     #lcd.display_off()
        # if count % 10 == 8:
        #     print("Turning display & backlight on")
        #     lcd.backlight_on()
        #     lcd.display_on()

#if __name__ == "__main__":
test_main()
