#
import time
import machine
import LCDisplayI2C
#
I2CADDRESS_LCDISPLAY_T  = 0x27
I2CADDRESS_LCDISPLAY_A  = 0x3F
#
LCDISPLAY_COUNT_ROWS    = 4
LCDISPLAY_COUNT_COLUMNS = 20
#
def TestLoop():
    for S in range(0, 10):
        LCDisplay.MoveTo(0, 0)
        LCDisplay.PutText('********************')
        LCDisplay.MoveTo(1, 0)
        LCDisplay.PutText('* Esp32LCDisplay   *')
        LCDisplay.MoveTo(2, 0)
        LCDisplay.PutText('* Version 01V01    *')
        LCDisplay.MoveTo(3, 0)
        LCDisplay.PutText('********************')
        time.sleep_ms(2000)
        LCDisplay.Clear()
        for P in range(0, 30):
            LCDisplay.MoveTo(0, 0)
            LCDisplay.PutText('Line0[{}]'.format(time.ticks_ms()))
            LCDisplay.MoveTo(1, 0)
            LCDisplay.PutText('Line1[{}]'.format(time.ticks_ms()))
            LCDisplay.MoveTo(2, 0)
            LCDisplay.PutText('Line2[{}]'.format(time.ticks_ms()))
            LCDisplay.MoveTo(3, 0)
            LCDisplay.PutText('Line3[{}]'.format(time.ticks_ms()))
    #
#-------------------------------------------------------------    
if '__main__' == __name__:
    print('*** CheckEsp32LCDisplayI2C: begin')
    #
    I2CDisplay = machine.SoftI2C(scl=machine.Pin(22), sda=machine.Pin(21), freq=2000000) 
    LCDisplay = LCDisplayI2C.CLCDisplayI2C(I2CDisplay, I2CADDRESS_LCDISPLAY_T, \
                                           LCDISPLAY_COUNT_ROWS, LCDISPLAY_COUNT_COLUMNS)
    #
    TestLoop()
    #
    print('*** CheckEsp32LCDisplayI2C: end')
    #
#
