#
import time as TIM
#
import Define as DEF
import Uart as UART
#
#-------------------------------------------------------------------
#   Callback - Uart
#-------------------------------------------------------------------
def CBUartOnRxLine(rxline):
    print('CBUartOnRxLine[{}]'.format(rxline))
#
def CBUartOnTxLine(txline):
    print('CBUartOnTxLine[{}]'.format(txline))
#
#-------------------------------------------------------------------
#   Main - Uart
#-------------------------------------------------------------------
if ('__main__' == __name__):
    print('*** Esp32CheckUart: begin')    
    #
    Uart = UART.CUart(DEF.ID_UART1, DEF.PIN_UART1_TX, DEF.PIN_UART1_RX)
    Uart.SetOnRxLine(CBUartOnRxLine)
    Uart.SetOnTxLine(CBUartOnTxLine)
    Uart.Open()
    #
    Uart.TxLine('000 <command>')
    Uart.TxLine('111 <command> <parameter0>')
    Uart.TxLine('222 <command> <parameter0> <parameter1>')
    Uart.TxLine('333 <command> <parameter0> <parameter1> <parameter2>')
    Uart.TxLine('444 <command> <parameter0> <parameter1> <parameter2> <parameter3>')
    Uart.TxLine('555 <command>')
    Uart.TxLine('666 <command> <parameter0>')
    Uart.TxLine('777 <command> <parameter0> <parameter1>')
    Uart.TxLine('888 <command> <parameter0> <parameter1> <parameter2>')
    Uart.TxLine('999 <command> <parameter0> <parameter1> <parameter2> <parameter3>')
    TIM.sleep(2.0)
    #
    Uart.Close()
    #
    print('*** Esp32CheckUart: end')
    #
#