#
import time
from machine import UART
#
import Define
import Lines as LIN
import Thread as THR
#
class CUart():
    #---------------------------------------------------------
    #   Constructor
    #---------------------------------------------------------
    def __init__(self, uartid, txpin, rxpin):
        self.Uart = UART(uartid, tx=txpin, rx=rxpin)
        self.TxLines = LIN.CLines()
        self.RxLines = LIN.CLines() 
        self.Thread = THR.CThread(self.CBOnStart, self.CBOnBusy, self.CBOnAbort, self.CBOnEnd)
        self.RxLine = ''
    #---------------------------------------------------------
    #   Property
    #---------------------------------------------------------
    def SetParentOnRxLine(self, parentonrxline):
        self.ParentOnRxLine = parentonrxline
    def SetParentOnTxLine(self, parentontxline):
        self.ParentOnTxLine = parentontxline
    #---------------------------------------------------------
    #   Callback Thread
    #---------------------------------------------------------
    def CBOnStart(self, thread):
        return
    def CBOnBusy(self, thread):
        while (THR.stBusy == thread.State):
            # first: RxData
            while (0 < self.Uart.any()):
                C = self.Uart.read(1)
                if (b'\r' == C) or (b'\n' == C):
                    if (0 < len(self.RxLine)):
                        self.RxLines.Push(self.RxLine)
                        self.RxLine = '';
                else:
                    self.RxLine += C.decode("utf-8")
            if (0 < self.RxLines.Count()):
                RxLine = self.RxLines.Pop()
                self.OnRxLine(RxLine)
            # second: TxData
            if (0 < self.TxLines.Count()):
                TxLine = self.TxLines.Pop()
                self.OnTxLine(TxLine)
                self.Uart.write(TxLine + '\r\n')
        return
    def CBOnAbort(self, thread):
        return
    def CBOnEnd(self, thread):
        return
    #---------------------------------------------------------
    #   Callback Rxd/Txd
    #---------------------------------------------------------
    def OnRxLine(self, rxline):
        if (None != self.ParentOnTxLine):
            self.ParentOnRxLine(rxline)
    #
    def OnTxLine(self, txline):
        if (None != self.ParentOnTxLine):
            self.ParentOnTxLine(txline)
    #---------------------------------------------------------
    #   Management
    #---------------------------------------------------------
    def Open(self):
        self.Uart.init(baudrate=115200)#, bits=8, parity=None, stop=1, cts=-1, rts=-1)
        self.Thread.Start()   
        self.RxLine = ''
        return
    #
    def Close(self):
        self.Thread.Abort()
        self.Uart.deinit()
        return 
    #
    def TxLine(self, line):
        self.TxLines.Push(line)
    #
#
#-------------------------------------------------------------
#   Uart - Main - Check Library
#-------------------------------------------------------------
#
def ParentOnRxLine(rxline):
    print('Parent.OnRxLine[{}]'.format(rxline))
    return
#    
def ParentOnTxLine(txline):
    print('Parent.OnTxLine[{}]'.format(txline))
    return
#
if ('__main__' == __name__):    
    print('*** CheckUart: begin')
    #
    Uart = CUart(Define.ID_UART1, Define.PIN_UART1_TX, Define.PIN_UART1_RX)
    Uart.SetParentOnRxLine(ParentOnRxLine)
    Uart.SetParentOnTxLine(ParentOnTxLine)
    Uart.Open()
    #
    Uart.TxLine('000asdf')
    Uart.TxLine('111asdf')
    time.sleep(2.0)
    Uart.TxLine('222asdf')
    Uart.TxLine('333asdf')
    time.sleep(2.0)
    Uart.TxLine('444asdf')
    Uart.TxLine('555asdf')
    time.sleep(2.0)
    #
    Uart.Close()
    #
    print('*** CheckUart: end')
#    