#
import time
import machine
#
import Define as DEF
import Thread as THR
import Uart as URT
import Keyboard4x4 as KBD
import LCDisplayI2C as LCD
import ThreadDisplay as TDP
#
#
#------------------------------------------------------------------
#   Main
#------------------------------------------------------------------

def ParentOnRxLine(rxline):
    print('Parent.OnRxLine[{}]'.format(rxline))
    return
#    
def ParentOnTxLine(txline):
    print('Parent.OnTxLine[{}]'.format(txline))
    return
#
if ('__main__' == __name__):
    print('*** Esp32UartBtWlan: begin')
    # Constructor:
    UartPC = URT.CUart(DEF.ID_UART1, DEF.PIN_UART1_TX, DEF.PIN_UART1_RX)
    UartPC.SetParentOnRxLine(ParentOnRxLine)
    UartPC.SetParentOnTxLine(ParentOnTxLine)
    UartUC = URT.CUart(DEF.ID_UART2, DEF.PIN_UART2_TX, DEF.PIN_UART2_RX)
    #BtPH = BT.CBt()
    #WlanTB = WLN.CWlan()
    Keyboard = KBD.CKeyboard4x4(DEF.PIN_KEYBOARD_IN0, DEF.PIN_KEYBOARD_IN1,
                                DEF.PIN_KEYBOARD_IN2, DEF.PIN_KEYBOARD_IN3,
                                DEF.PIN_KEYBOARD_OUT0, DEF.PIN_KEYBOARD_OUT1,
                                DEF.PIN_KEYBOARD_OUT2, DEF.PIN_KEYBOARD_OUT3)
    #
    # Open:
    UartPC.Open()
    UartUC.Open()
    # BtPH.Open()
    # WlanTB.Open
    # Display
    I2CDisplay = machine.SoftI2C(scl=machine.Pin(22), sda=machine.Pin(21), freq=2000000) 
    LCDisplay = LCD.CLCDisplayI2C(I2CDisplay, DEF.I2CADDRESS_LCDISPLAY_T, \
                                  DEF.LCDISPLAY_COUNT_ROWS, DEF.LCDISPLAY_COUNT_COLUMNS)
    ThreadDisplay = TDP.CThreadDisplay(I2CDisplay, LCDisplay)
    # Keyboard
    Keyboard.Open()
    #
    # MainLoop
    MainCount = 0
    DEF.MAINLOOP = True
    while (DEF.MAINLOOP): 
        MainCount += 1
        KeyCode = Keyboard.GetKeyCode()
        if (24 == KeyCode):
            DEF.MAINLOOP = False
        else:
            if (0 < KeyCode):
                print(KeyCode)
        #
        if (100 == MainCount):
            UartPC.TxLine('Hello1')
        if (200 == MainCount):
            UartPC.TxLine('Hello2')
        if (300 == MainCount):
            UartPC.TxLine('Hello3')
        if (400 == MainCount):
            UartPC.TxLine('Hello4')
        if (500 == MainCount):
            UartPC.TxLine('Hello5')
        time.sleep(0.001)
    print(MainCount)
    #
    # Close:
    UartPC.Close()
    UartUC.Close()
    # BtPH.Close()
    # WlanTB.Close()
    Keyboard.Close()
    #
    print('*** Esp32UartBtWlan: end')
    #
#