#
import time
import socket as SKT
import network as NTW
import Thread as THR
#
class CUdpClientServer():
    #
    def __init__(self, wlanssid, wlanpw,
                 headerid, ipportrx, \
                 ipaddresstx, ipporttx, \
                 ontxdata, onrxdata):   
        self.WlanSSID = wlanssid
        self.WlanPW = wlanpw            
        self.HeaderID = headerid
        self.IPAddressRXLocal = ''
        self.IPPortRX = ipportrx
        self.IPAddressTX = ipaddresstx
        self.IPPortTX = ipporttx
        self.OnTxData = ontxdata
        self.OnRxData = onrxdata
        self.Thread = THR.CThread(self.CBOnStart, self.CBOnBusy, \
                                  self.CBOnAbort, self.CBOnEnd)
        self.Wlan = None
        self.RxSocket = None
        self.TxSocket = None
        #
        self.DEBUG = False
        #
        return
    #
    def GetHeaderID(self):
        return self.HeaderID
    def GetIPAddressTX(self):
        return self.IPAddressTX
    def GetIPPortTX(self):
        return self.IPPortTX
    def GetIPAddressRXLocal(self):
        return self.IPAddressRXLocal
    def GetIPPortRX(self):
        return self.IPPortRX
    #
    def IsBusy(self):
        return THR.stBusy == self.Thread.State
    #
    def CBOnStart(self, thread):
        if self.DEBUG:
            print('UdpClientServer.CBOnStart')
        return    
    #
    def CBOnBusy(self, thread):
        if self.DEBUG:
            print('UdpClientServer.CBOnBusy')
        while self.IsBusy():
            RxData = ''
            try:
                Data, Address = self.RxSocket.recvfrom(1024)
                RxData = Data.decode('utf-8')
            except:
                pass 
            else:
                if self.DEBUG:
                    print('!!!!!!!!RxData[{}]'.format(Data.decode('utf-8')))
                if (None != self.OnRxData):
                    self.OnRxData(self, RxData)
            finally:
                time.sleep(0.1)            
        self.RxSocket.close()
        return    
    #
    def CBOnAbort(self, thread):
        if self.DEBUG:
            print('UdpClientServer.CBOnAbort')
        self.RxSocket.close()
        return
    #
    def CBOnEnd(self, thread):
        if self.DEBUG:
            print('UdpClientServer.CBOnEnd')
        self.RxSocket.close()
        return
    #
    def Open(self):
        self.Wlan = NTW.WLAN(NTW.STA_IF)
        self.Wlan.active(False)
        self.Wlan.active(True)
        self.Wlan.connect(self.WlanSSID, self.WlanPW)
        while not(self.Wlan.isconnected()):
            pass
        self.IPAddressRXLocal = self.Wlan.ifconfig()[0]
        if self.DEBUG:
            print('Wlan-IDs[{}]'.format(self.Wlan.ifconfig()))
            print('Wlan-LocalIPAddress[{}]'.format(self.IPAddressRXLocal))
        # Rx
        if (THR.stBusy == self.Thread.State):
            self.Thread.Abort()
        self.RxSocket = SKT.socket(SKT.AF_INET, SKT.SOCK_DGRAM)
        # FORWARD Socket.bind !!!
        self.RxSocket.setsockopt(SKT.SOL_SOCKET, SKT.SO_REUSEADDR, 1)
        self.RxSocket.bind((self.IPAddressRXLocal, self.IPPortRX))
        self.RxSocket.setblocking(0)
        self.Thread.Start()
        # Tx
        self.TxSocket = SKT.socket(SKT.AF_INET, SKT.SOCK_DGRAM)
        self.TxSocket.connect((self.IPAddressTX, self.IPPortTX))
        return   
    #
    def Close(self):
        if self.DEBUG:
            print('UdpClientServer.Close')
        self.Thread.Abort()
        self.RxSocket.close()
        self.TxSocket.close()
    #
    def Abort(self):
        if self.DEBUG:
            print('UdpClientServer.Abort')
        self.Thread.Abort()
        return
    #
    def Transmit(self, text):
        if self.DEBUG:
            print('UdpClientServer.Transmit')
        if (None != self.OnTxData):
            self.OnTxData(self, text)
        self.TxSocket.sendto(text.encode('utf-8'), \
                                         (self.IPAddressTX, self.IPPortTX))
    #
    def Execute(self):
        return
    #     
# #
# #-----------------------------------------------------------
# #   Check UdpClientServer
# #-----------------------------------------------------------
# WLAN_SSID = 'FritzBoxSA7'
# WLAN_PW = '01234567890123456789'
# #
# UDP_HEADERID = 'UDPHID'
# #-----------------------------------------------------------
# #   UDP - TxD - TransmitData
# #-----------------------------------------------------------
# # UDP_IPADDRESS_TX = '192.168.178.255' NO broadcasting to local
# UDP_IPADDRESS_TX = '192.168.178.71'
# UDP_IPPORT_TX = 5000
# #
# #-----------------------------------------------------------
# #   UDP - RxD - ReceiveData
# #-----------------------------------------------------------
# UDP_IPADDRESS_LOCAL = '192.168.178.71' # dummy
# UDP_IPPORT_RX = 5000
# #   
# #-----------------------------------------------------------
# #   Callback - UdpClient
# #-----------------------------------------------------------
# def CBOnTxData(udpclientserver, txdata):
#     Line = 'UdpClientServer.CBOnTxData[{}]<{}>'.format(udpclientserver.GetHeaderID(), txdata)
#     print(Line)
#     return
# #
# def CBOnRxData(udpclientserver, rxdata):
#     Line = 'UdpClientServer.CBOnRxData[{}]<{}>'.format(udpclientserver.GetHeaderID(), rxdata)
#     print(Line)
#     return
# #
# if ('__main__' == __name__):
#     #
#     print('*** Check UdpClientServer: begin')        
#     #
#     UdpCS = CUdpClientServer(WLAN_SSID, WLAN_PW,
#                              UDP_HEADERID, UDP_IPPORT_RX,
#                              UDP_IPADDRESS_TX, UDP_IPPORT_TX, 
#                              CBOnTxData, CBOnRxData)
#     UdpCS.Open()    
#     #
#     print('{}: TxIP-Address[{}]-Port[{}]'.format(UdpCS.GetHeaderID(), 
#                                                  UdpCS.GetIPAddressTX(), 
#                                                  UdpCS.GetIPPortTX()))
#     print('{}: RxIP-Address[{}]-Port[{}](local)'.format(UdpCS.GetHeaderID(), 
#                                                  UdpCS.GetIPAddressRXLocal(),
#                                                  UdpCS.GetIPPortRX()))
#     #
#     UdpCS.Transmit('HalloA')
#     time.sleep(1.0)
#     UdpCS.Transmit('HalloB')
#     time.sleep(1.0)
#     UdpCS.Transmit('HalloC')
#     time.sleep(1.0)
#     #
#     UdpCS.Close() 
#     #
#     print('*** Check UdpClientServer: end')
#     #
# #
