#
# Syntax-Arguments: <headerid> <rxipport> <txipaddress> <txipport>
#
# WindowsPC[192.168.178.33] <-> # WindowsPC[192.168.178.33]:
# WinPC: python CheckUdpClientServer.py Windows 4321 192.168.178.33 4321


# WindowsPC[192.168.178.33] <-> UbuntuPC[192.168.178.48]
# WinPC: python CheckUdpClientServer.py Windows 5001 192.168.178.48 5000
# LinPC: python CheckUdpClientServer.py Ubuntu  5000 192.168.178.33 5001 
#
import sys
import time
import socket as SKT
#
import Thread as THR
import WlanUdp as WLU
#
WLAN_SSID = 'FritzBoxSA7'
WLAN_PW = '01234567890123456789'
#
UDP_HEADERID = 'UDPHID'
#-----------------------------------------------------------
#   UDP - TxD - TransmitData
#-----------------------------------------------------------
# UDP_IPADDRESS_TX = '192.168.178.255' NO broadcasting to local
UDP_IPADDRESS_TX = '192.168.178.255'
UDP_IPPORT_TX = 5000
#
#-----------------------------------------------------------
#   UDP - RxD - ReceiveData
#-----------------------------------------------------------
UDP_IPADDRESS_LOCAL = '192.168.178.71' # dummy
UDP_IPPORT_RX = 5001
#   
#-----------------------------------------------------------
#   Callback - UdpClient
#-----------------------------------------------------------
def CBOnTxData(udpclientserver, txdata):
    Line = 'CBOnTxData[{}]<{}>'.format(udpclientserver.GetHeaderID(), txdata)
    print(Line)
    return
#
def CBOnRxData(udpclientserver, rxdata):
    Line = 'CBOnRxData[{}]<{}>'.format(udpclientserver.GetHeaderID(), rxdata)
    print(Line)
    return
# 
#-----------------------------------------------------------
#   Main
#-----------------------------------------------------------
if ('__main__' == __name__):
    #
    print('*** Esp32WlanUdpThread: begin')
    #
    MillisPreset = time.ticks_ms() - 100000
    #
    UdpCS = WLU.CWlanUdp(WLAN_SSID, WLAN_PW,
                         UDP_HEADERID, UDP_IPPORT_RX,
                         UDP_IPADDRESS_TX, UDP_IPPORT_TX, 
                         CBOnTxData, CBOnRxData)
    UdpCS.Open()
    #        
    print('{}: TxIP-Address[{}]-Port[{}]'.format(UdpCS.GetHeaderID(), 
                                                 UdpCS.GetIPAddressTX(), 
                                                 UdpCS.GetIPPortTX()))
    print('{}: RxIP-Address[{}]-Port[{}](local)'.format(UdpCS.GetHeaderID(), 
                                                 UdpCS.GetIPAddressRXLocal(),
                                                 UdpCS.GetIPPortRX()))
    while UdpCS.IsBusy():
        UdpCS.Execute()
        if 10000 <= (time.ticks_ms() - MillisPreset):
            MillisPreset = time.ticks_ms()
            UdpCS.Transmit('! Millis[{}]ms'.format(MillisPreset))
    UdpCS.Close()
    #
    print('*** Esp32WlanUdpThread: end')
    #
#
