#
import sys
import time
import socket as SKT
#
import Define as DEF
import Thread as THR
import WlanUdp as WLU
import Lines as LIN
import LedSystem as LS
#   
#-----------------------------------------------------------
#   Callback - UdpClient
#-----------------------------------------------------------
# ok, but not used 
# def CBOnTxData(udpclientserver, txdata):
#     if DEF.DEBUG_MAIN:
#         Line = 'CBOnTxData[{}]<{}>'.format(udpclientserver.GetHeaderID(), txdata)
#         print(Line)
#     return
#
# ok, but not used 
# def CBOnRxData(udpclientserver, rxdata):
#     if DEF.DEBUG_MAIN:
#         Line = 'CBOnRxData[{}]<{}>'.format(udpclientserver.GetHeaderID(), rxdata)
#         print(Line)
#     return
# 
def ExecuteLocalDispatcher(rxline):
    print(len(rxline), rxline)
    if (4 <= len(rxline)):
        if ('@' == rxline[0]):
            if (0 < rxline.find('LSF', 1)):
                print('LedSystem[OFF]')
                return True
            if (0 < rxline.find('LSO')):
                print('LedSystem[ON]')
                return True
    return False
#
def ExecuteChildDispatcher(rxline):
    return False
#
def ExecuteDispatcher(rxline):
    if (0 < len(rxline)):
        print('ExecuteDispatcher[{}]'.format(rxline))
        if ExecuteLocalDispatcher(rxline):
            return True
        if ExecuteChildDispatcher(rxline):
            return True
    return False
#
#-----------------------------------------------------------
#   Main
#-----------------------------------------------------------
# Uart-PC
# UartPC = URT.CUart(...)
# Bt-AndroidDevice
# BtAD = BT.CBt(...)
# Wlan-Udp-PC
WlanUdpPC = WLU.CWlanUdp(DEF.WLAN_SSID, DEF.WLAN_PW,
                         DEF.UDP_HEADERID, DEF.UDP_IPPORT_RX,
                         DEF.UDP_IPADDRESS_TX, DEF.UDP_IPPORT_TX, 
                         # ok but not used CBOnRxData, CBOnTxData)
                         None, None)
 

if ('__main__' == __name__):
    #
    print('*** Esp32WlanUdpThread: begin')
    #
    MillisStart = time.ticks_ms()
    #
    # Open InterfaceCommunication
    # UartPC.Open()
    # BtAD.Open()
    WlanUdpPC.Open()
    LedSystem = LS.CLedSystem(2)
    LedSystem.Open()
    for BI in range(0, 10):
        LedSystem.SetOn()
        time.sleep(0.1)
        LedSystem.SetOff()
        time.sleep(0.1)
    #    
    while WlanUdpPC.IsBusy():
        # UartPC.Execute()
        # BtAD.Execute()
        WlanUdpPC.Execute()
        #
        RxLine = WlanUdpPC.ReadLine()
        ExecuteDispatcher(RxLine)
        #
        if 20000 <= (time.ticks_ms() - MillisStart):
            WlanUdpPC.Abort()
    #        
    # UartPC.Close()
    # BtAD.Close()
    WlanUdpPC.Close()
    LedSystem.Close()
    #
    print('*** Esp32WlanUdpThread: end')
    #
#





#----------------------------------------------------------------------
    #MillisPreset = time.ticks_ms() - 100000
        # if 10000 <= (time.ticks_ms() - MillisPreset):
        #     MillisPreset = time.ticks_ms()
        #     WlanUdpPC.Transmit('! Millis[{}]ms'.format(MillisPreset))
