#
import time
import socket as SKT
import network as NTW
#
import Define as DEF
import Thread as THR
import Lines as LIN
#
class CWlanUdp():
    #
    def __init__(self, wlanssid, wlanpw,
                 headerid, ipportrx, \
                 ipaddresstx, ipporttx, \
                 onrxdata, ontxdata):   
        self.WlanSSID = wlanssid
        self.WlanPW = wlanpw            
        self.HeaderID = headerid
        self.IPAddressRXLocal = ''
        self.IPPortRX = ipportrx
        self.IPAddressTX = ipaddresstx
        self.IPPortTX = ipporttx
        self.OnRxData = onrxdata
        self.OnTxData = ontxdata
        self.Thread = THR.CThread(self.CBOnStart, self.CBOnBusy, \
                                  self.CBOnAbort, self.CBOnEnd)
        self.Wlan = None
        self.RxSocket = None
        self.TxSocket = None
        #
        self.RxLines = LIN.CLines()
        self.TxLines = LIN.CLines()
        #
        return
    #
    def GetHeaderID(self):
        return self.HeaderID
    def GetIPAddressTX(self):
        return self.IPAddressTX
    def GetIPPortTX(self):
        return self.IPPortTX
    def GetIPAddressRXLocal(self):
        return self.IPAddressRXLocal
    def GetIPPortRX(self):
        return self.IPPortRX
    #
    def IsBusy(self):
        return THR.stBusy == self.Thread.State
    #








    def CBOnStart(self, thread):
        if DEF.DEBUG_WLANUDP:
            print('UdpClientServer.CBOnStart')
        return    
    #
    def CBOnBusy(self, thread):
        if DEF.DEBUG_WLANUDP:
            print('UdpClientServer.CBOnBusy')
        RxLine = ''       
        while self.IsBusy():
            try:
                RxBuffer, Address = self.RxSocket.recvfrom(1024)
                RxSize = len(RxBuffer)
                RxText = RxBuffer.decode()
                if DEF.DEBUG_WLANUDP:
                    print('RxSize[{}]Buffer<{}>Text<{}>'.format(RxSize, RxBuffer, RxText))
                for CI in range(0, RxSize):
                    AC = RxText[CI]
                    if DEF.DEBUG_WLANUDP:
                        print('I[{}]AC[{}]Text<{}>'.format(CI, AC, RxText[CI]))
                    if (('\r' == AC) or ('\n' == AC)):
                        if (0 < len(RxLine)):
                            self.RxLines.Push(RxLine)
                            if (None != self.OnRxData):
                                self.OnRxData(self, RxLine)
                            if DEF.DEBUG_WLANUDP:
                                print('RxLine[{}]Count[{}]'.format(RxLine, self.RxLines.Count()))
                        RxLine = ''
                    else:
                        if DEF.DEBUG_WLANUDP:
                            print('I[{}]AC[{}]'.format(CI, AC))
                        RxLine += AC
                #
                if (0 < self.TxLines.Count()):
                    TxLine = self.TxLines.Pop()
                    self.TxSocket.sendto(TxLine.encode('utf-8'), \
                                            (self.IPAddressTX, self.IPPortTX))
            except:
                # permanent error???!!! print('???')
                pass 
            finally:
                time.sleep(0.1)
        self.RxSocket.close()
        self.TxSocket.close()
        return    
    #
    def CBOnAbort(self, thread):
        if DEF.DEBUG_WLANUDP:
            print('UdpClientServer.CBOnAbort')
        self.RxSocket.close()
        self.TxSocket.close()
        return
    #
    def CBOnEnd(self, thread):
        if DEF.DEBUG_WLANUDP:
            print('UdpClientServer.CBOnEnd')
        self.RxSocket.close()
        self.TxSocket.close()
        return
    #
    #----------------------------------------------------------------------------------------------
    def Open(self):
        self.Wlan = NTW.WLAN(NTW.STA_IF)
        self.Wlan.active(False)
        self.Wlan.active(True)
        self.Wlan.connect(self.WlanSSID, self.WlanPW)
        while not(self.Wlan.isconnected()):
            pass
        self.IPAddressRXLocal = self.Wlan.ifconfig()[0]
        if DEF.DEBUG_WLANUDP:
            print('Wlan-IDs[{}]'.format(self.Wlan.ifconfig()))
            print('Wlan-LocalIPAddress[{}]'.format(self.IPAddressRXLocal))
        # Rx
        if (THR.stBusy == self.Thread.State):
            self.Thread.Abort()
        self.RxSocket = SKT.socket(SKT.AF_INET, SKT.SOCK_DGRAM)
        # FORWARD Socket.bind !!!
        self.RxSocket.setsockopt(SKT.SOL_SOCKET, SKT.SO_REUSEADDR, 1)
        self.RxSocket.bind((self.IPAddressRXLocal, self.IPPortRX))
        self.RxSocket.setblocking(1)
        self.Thread.Start()
        # Tx
        self.TxSocket = SKT.socket(SKT.AF_INET, SKT.SOCK_DGRAM)
        self.TxSocket.connect((self.IPAddressTX, self.IPPortTX))
        #
        # if DEF.DEBUG_WLANUDP:
        print('{}: TxIP-Address[{}]-Port[{}]'.format(self.GetHeaderID(), 
                                                    self.GetIPAddressTX(), 
                                                    self.GetIPPortTX()))
        print('{}: RxIP-Address[{}]-Port[{}](local)'.format(self.GetHeaderID(), 
                                                            self.GetIPAddressRXLocal(),
                                                            self.GetIPPortRX()))
        return   
    #
    def Close(self):
        if DEF.DEBUG_WLANUDP:
            print('UdpClientServer.Close')
        self.Thread.Abort()
        self.RxSocket.close()
        self.TxSocket.close()
    #
    def Abort(self):
        if DEF.DEBUG_WLANUDP:
            print('UdpClientServer.Abort')
        self.Thread.Abort()
        self.RxSocket.close()
        self.TxSocket.close()
        return
    #
    def WriteLine(self, txline):
        if DEF.DEBUG_WLANUDP:
            print('UdpClientServer.Transmit[{}]'.format(txline))
        if (None != self.OnTxData):
            self.OnTxData(self, txline)
        self.TxLines.Push(txline)
    #
    def ReadLine(self):
        return self.RxLines.Pop()
    #
    def Execute(self):
        return
    #     
#