import time
import _thread as THR
# States
stIdle = 0
stBusy = 1
stEnd = 2
#
class CThread():
    #
    def __init__(self, onstart, onbusy, onabort, onend):
        self.State = stIdle        
        self.Thread = None
        self.OnStart = onstart
        self.OnBusy = onbusy
        self.OnAbort = onabort
        self.OnEnd = onend
        return
    #
    def Start(self):
        self.State = stBusy
        if (None != self.OnStart):
            self.OnStart(self)
        self.ThreadID = THR.start_new_thread(self.CBOnExecute, [self])
        return    
    #
    def Abort(self):
        self.State = stEnd
        if (None != self.OnAbort):
            self.OnAbort(self)
        return
    #
    def CBOnExecute(self, thread):
        if (None != self.OnBusy):
            self.OnBusy(self)
        if (None != self.OnEnd):
            self.OnEnd(self)
        return
    #

#
#   
#-----------------------------------------------------------
#   Check Thread
#-----------------------------------------------------------
def CBOnStart(thread):
    print('CBOnStart')
    return
def CBOnBusy(thread):
    print('CBOnBusy')
    Counter = 0
    while (stBusy == thread.State):
        Counter += 1
        print(Counter)
        if (3 <= Counter):
            thread.Abort()
        else:
            time.sleep(1.0)
    return
def CBOnAbort(thread):
    print('CBOnAbort')
    return
def CBOnEnd(thread):
    print('CBOnEnd')
    return
#
if ('__main__' == __name__):
    #
    print('*** Check Thread: begin')        
    #
    Thread = CThread(CBOnStart, CBOnBusy, CBOnAbort, CBOnEnd)
    Thread.Start()
    time.sleep(5.0)
    Thread.Abort()
    #
    print('*** Check Thread: end')
    #
#

