import time
#
import Thread as THR
#
class CProcess():
    #
    def __init__(self, processid, filename):
        self.ID = processid
        self.Filename = filename
        self.Thread = THR.CThread(self.CBOnStart, self.CBOnBusy, \
                                  self.CBOnAbort, self.CBOnEnd)
    #
    def CBOnStart(self, thread):
        print('CBOnStart[{}]'.format(self.ID))
        return
    def CBOnBusy(self, thread):
        print('CBOnBusy[{}]'.format(self.ID))
        execfile(self.Filename)
        return
    def CBOnAbort(self, thread):
        print('CBOnAbort[{}]'.format(self.ID))
        return
    def CBOnEnd(self, thread):
        print('CBOnEnd[{}]'.format(self.ID))
        return
    #
    def GetID(self):
        return self.ID
    #
    def Start(self):
        self.Thread.Start()
    #
    def Abort(self):
        self.Thread.Abort()
    #
#
#   
#-----------------------------------------------------------
#   Check Process
#-----------------------------------------------------------
#
if ('__main__' == __name__):
    #
    print('*** Check Process: begin')        
    #
    ProcessCU = CProcess('CU', 'CountUp.py')
    ProcessCD = CProcess('CD', 'CountDown.py')
    ProcessCU.Start()
    ProcessCD.Start()
    time.sleep(5.0)
    ProcessCU.Abort()
    ProcessCD.Abort()
    time.sleep(1.0)
    #
    print('*** Check Process: end')
    #
#


