import tkinter as TKI
import tkinter.ttk as TKK
from enum import Enum as ENM
#
VALUE_CW  = '          CW         '
VALUE_CCW = '          CCW        '
#
class EStateSpindle(ENM):
    ssIdle = 0
    ssBusyCW = 1
    ssBusyCCW = 2
#
class CFrameSpindle(TKI.Frame):
    def __init__(self, frameparent,
                 width, height, sizex, sizey):
        TKI.Frame.__init__(self, frameparent)
        self.FrameParent = frameparent
        #
        self.Header = 'Spindle'
        self.NameU = 'Speed [rpm]'
        self.NameD = 'Direction'
        self.CommandI = 'Idle'
        self.CommandCW = 'Rotate CW'
        self.CommandCCW = 'Rotate CCW'
        #
        self.SX = width
        self.SY = height
        self.DY = 20
        #
        self.lblHeader = TKI.Label(self, text=self.Header)
        self.lblHeader.place(x=0, y=0, width=self.SX,
                             height=self.DY, anchor='nw')
        #
        self.lblNameU = TKI.Label(self, text=self.NameU)
        self.lblNameU.place(x=0, y=20, width=self.SX,
                           height=self.DY, anchor='nw')
        #
        self.entSpeed = TKI.Spinbox(self, justify='center',
                                    from_= 0.0, to = 20000,
                                    increment=1000)#,
                                    #state = TKI.READONLY)
        self.entSpeed.place(x=0, y=40, width=self.SX,
                            height=self.DY, anchor='nw')
        self.SetText(self.entSpeed, '0')
        #
        self.lblNameD = TKI.Label(self, text=self.NameD)
        self.lblNameD.place(x=0, y=60, width=self.SX,
                            height=self.DY, anchor='nw')
        #
        SM = TKK.Style()
        SM.map('TCombobox', fieldbackground=[('readonly','white')])
        SM.map('TCombobox', selectbackground=[('readonly', 'white')])
        SM.map('TCombobox', selectforeground=[('readonly', 'black')])
        self.cbxDirection = TKK.Combobox(self, state="readonly", justify='center')
        self.cbxDirection.place(x=0, y=80, width=self.SX,
                                height=self.DY, anchor='nw')
        self.cbxDirection['values'] = (VALUE_CW, VALUE_CCW)
        self.cbxDirection.bind('<<ComboboxSelected>>', self.OnDirectionSelected)
        self.cbxDirection.current(0)
        #
        self.btnCommand = TKI.Button(self, text=self.CommandCW,
                                     command=self.OnButtonClick)
        self.btnCommand.place(x=0, y=self.SY, width=self.SX,
                              height=self.DY, anchor='sw')
        #
        self.State = EStateSpindle.ssIdle
        return
    #--------------------------------------------------
    # Property - private
    #--------------------------------------------------
    def SetText(self, widget, text):
        widget.delete(0, TKI.END)
        widget.insert(0, text)
        return
    #--------------------------------------------------
    # Property - public
    #--------------------------------------------------
    def SetState(self, state):
        self.State = state
        if (EStateSpindle.ssBusyCW == self.State):
            self.btnCommand['text'] = self.CommandI
            self.cbxDirection['state'] = 'disabled'
        elif (EStateSpindle.ssBusyCCW == self.State):
            self.btnCommand['text'] = self.CommandI
            self.cbxDirection['state'] = 'disabled'
        else: # Idle
            CBV = self.cbxDirection.get()
            self.cbxDirection['state'] = 'readonly'
            if (VALUE_CW == CBV): # show cw
                self.btnCommand['text'] = self.CommandCW
            elif (VALUE_CCW == CBV): #show ccw
                self.btnCommand['text'] = self.CommandCCW
        return
    #--------------------------------------------------
    # Callback - private
    #--------------------------------------------------
    def OnDirectionSelected(self, event):
        if (EStateSpindle.ssIdle == self.State):
            self.SetState(EStateSpindle.ssIdle)
        return

    def OnButtonClick(self):
        if (EStateSpindle.ssIdle == self.State):
            CBV = self.cbxDirection.get()
            if (VALUE_CW == CBV): # run cw
                self.SetState(EStateSpindle.ssBusyCW)
            elif (VALUE_CCW == CBV): #run ccw
                self.SetState(EStateSpindle.ssBusyCCW)
        else: # stop
            self.SetState(EStateSpindle.ssIdle)
        return
    #
    #
#
#

