import tkinter as TKI
#from tkinter import ttk as TTK
#
import FrameButtons as FBS
import FramePositions as FPS
import FrameSpindles as FSS
#
TITLE_APPLICATION = 'FrameControls'
#
class CFrameApplication(TKI.Frame):
    def __init__(self, frameparent, *args, **kwargs):
        TKI.Frame.__init__(self, frameparent, *args, **kwargs)
        self.FrameParent = frameparent
        #
        self.FrameParent.geometry('1000x600+2022+422')
        #self.FrameParent.geometry('1000x600-1930+22')
        self.FrameParent.title(TITLE_APPLICATION)
        self.FrameParent['background'] = '#b4aaaa'
        #--------------------------------------------------------
        # FCS
        #--------------------------------------------------------
        self.frmButtons = FBS.CFrameButtons(self.FrameParent)
        self.frmButtons.place(x=20, y=20, width=260, height=162)
        #
        self.frmPositions = FPS.CFramePositions(self.FrameParent)
        self.frmPositions.place(x=20, y=200, width=308, height=126)
        self.frmPositions.frmPositionX.SetOnMoveAbsolute(self.OnMoveAbsoluteX)
        self.frmPositions.frmPositionX.SetOnMoveRelative(self.OnMoveRelativeX)
        self.frmPositions.frmPositionY.SetOnMoveAbsolute(self.OnMoveAbsoluteY)
        self.frmPositions.frmPositionY.SetOnMoveRelative(self.OnMoveRelativeY)
        self.frmPositions.frmPositionZ.SetOnMoveAbsolute(self.OnMoveAbsoluteZ)
        self.frmPositions.frmPositionZ.SetOnMoveRelative(self.OnMoveRelativeZ)
        #
        self.frmSpindles = FSS.CFrameSpindles(self.FrameParent)
        self.frmSpindles.place(x=328, y=200, width=104, height=126)
        self.frmSpindles.frmSpindle.SetOnRotateIdle(self.OnRotateIdle)
        self.frmSpindles.frmSpindle.SetOnRotateCW(self.OnRotateCW)
        self.frmSpindles.frmSpindle.SetOnRotateCCW(self.OnRotateCCW)
        #
        return
    #
    def OnMoveAbsoluteX(self, positionactual, positiontarget):
        print('X : Move Absolute : PA[{0}]mm PT[{1}]mm'.format(positionactual, positiontarget))
    def OnMoveRelativeX(self, positionactual, positiontarget):
        print('X : Move Relative : PA[{0}]mm PT[{1}]mm'.format(positionactual, positiontarget))
    #
    def OnMoveAbsoluteY(self, positionactual, positiontarget):
        print('Y : Move Absolute : PA[{0}]mm PT[{1}]mm'.format(positionactual, positiontarget))
    def OnMoveRelativeY(self, positionactual, positiontarget):
        print('Y : Move Relative : PA[{0}]mm PT[{1}]mm'.format(positionactual, positiontarget))
    #
    def OnMoveAbsoluteZ(self, positionactual, positiontarget):
        print('Z : Move Absolute : PA[{0}]mm PT[{1}]mm'.format(positionactual, positiontarget))
    def OnMoveRelativeZ(self, positionactual, positiontarget):
        print('Z : Move Relative : PA[{0}]mm PT[{1}]mm'.format(positionactual, positiontarget))
    #
    def OnRotateIdle(self):
        print('S : Rotate Idle')
    def OnRotateCW(self, speed):
        print('S : Rotate CW[{0}]rpm'.format(speed))
    def OnRotateCCW(self, speed):
        print('S : Rotate CCW[{0}]rpm'.format(speed))
    #
    def Execute(self):
        self.FrameParent.mainloop()
