#
import numpy as NUM
import matplotlib.pyplot as PLT
#
class CPlot2D():
    #
    def __init__(self):
        self.Figure = PLT.figure(figsize=(10, 10)) #, dpi=100)
        self.Axis = self.Figure.add_subplot(111)
        self.Axis.axis('equal')
        self.Axis.grid(visible=True)
        XTicks = NUM.arange(-30, 30, 1)
        YTicks = NUM.arange(-30, 30, 1)
        self.Axis.set_xticks(XTicks)
        self.Axis.set_yticks(YTicks)
        return
    #
    def Draw(self, vectorx, vectory, color):
        self.Axis.plot(vectorx, vectory, color)
        self.Axis.plot(vectorx[0], vectory[0], color='#FF00FF88', marker='o')
        self.Axis.plot(vectorx[-1], vectory[-1], color='#FF880088', marker='o')
