#
import numpy as NUM
#
import Helper as HLP
import Plot2D as P2D
#-----------------------------------------------------------
# Constant
#-----------------------------------------------------------
COUNT_POINTS = 100
#-----------------------------------------------------------
# Global Function
#-----------------------------------------------------------
def P0P1PmABR(p0, p1, pm):
    X0 = p0[0]
    Y0 = p0[1]
    X1 = p1[0]
    Y1 = p1[1]
    Xm = pm[0]
    Ym = pm[1]
    # D
    D2 = (X1 - X0) * (X1 - X0) + (Y1 - Y0) * (Y1 - Y0)
    # Pd
    Xd = X0 + (X1 - X0) / 2.0 # X0-Offset
    Yd = Y0 + (Y1 - Y0) / 2.0 # Y0-Offset
    # H2
    H2 = (Xd - Xm) * (Xd - Xm) + (Yd - Ym) * (Yd - Ym)
    # R2
    R2 = D2 / 4.0 + H2
    Radius = NUM.sqrt(R2)
    #
    Alpha = HLP.ArcTanPos(Y0 - Ym, X0 - Xm)
    Beta = HLP.ArcTanPos(Y1 - Ym, X1 - Xm)
    # 2pi-Correction ?!)
    # B == A -> 2pi
    if (Beta <= Alpha):
        Beta += HLP.PIDRAD
    #
    return [Alpha, Beta, Radius]
#-----------------------------------------------------------
if ('__main__' == __name__):
    print('*** GCodeG2: begin')
    #
    Plot2D = P2D.CPlot2D()
    #
    P0 = [9.0, 6.0] # PointActual
    P1 = [2.0, 7.0] # PointTarget
    Pm = [5.0, 3.0] # PointMiddle
    P0 = [ 2.0,  2.0] # PointActual
    P1 = [18.0,  7.5] # PointTarget
    Pm = [ 8.0, 10.5] # PointMiddle
    #
    #-------------------------------------
    # RotationPositive - CCW
    #-------------------------------------
    [A, B, R] = P0P1PmABR(P0, P1, Pm)
    VXP = []
    VYP = []
    for I in range(0, 1 + COUNT_POINTS):
        t = I / COUNT_POINTS
        SCA = (B - A) * t + A
        X = Pm[0] + R * NUM.cos(SCA)
        Y = Pm[1] + R * NUM.sin(SCA)
        VXP.append(X)
        VYP.append(Y)
    #
    #-------------------------------------
    # RotationNegative - CW
    #-------------------------------------
    [A, B, R] = P0P1PmABR(P0, P1, Pm)
    print(HLP.RadDeg(A), HLP.RadDeg(B))
    VXN = []
    VYN = []
    DAB = HLP.PIDRAD - B + A
    for I in range(0, 1 + COUNT_POINTS):
        t = I / COUNT_POINTS
        SCA = -DAB * t + A
        if SCA < 0:
            SCA += HLP.PIDRAD
        X = Pm[0] + R * NUM.cos(SCA)
        Y = Pm[1] + R * NUM.sin(SCA)
        VXN.append(X)
        VYN.append(Y)
    #
    Plot2D.Draw(VXP, VYP, '#4400FF88')
    Plot2D.Draw(VXN, VYN, '#BB00AA88')
    #
    print('*** GCodeG2: end')
    #
    #
#
#
############################################################
    #
    # VX = []
    # VY = []
    # for I in range(0, 1 + COUNT_POINTS):
    #     t = I / COUNT_POINTS
    #     SCA = (A - B) * t + B
    #     X = Pm[0] + R * NUM.cos(SCA)
    #     Y = Pm[1] + R * NUM.sin(SCA)
    #     VX.append(X)
    #     VY.append(Y)
    # Plot2D.Draw(VX, VY, '#00FF88')
    #
    # Test: DegRad vv
    # for W in range(0, 370, 10):
    #     print(W, HLP.DegRad(W), HLP.RadDeg(HLP.DegRad(W)))
    #
    # Test: ArcTanPos
    # for WD in range(0, 370, 10):
    #     WR = HLP.DegRad(WD)
    #     DX = 1.0 * NUM.cos(WR)
    #     DY = 1.0 * NUM.sin(WR)
    #     AR = HLP.ArcTanPos(DY, DX)
    #     print(WD, DX, DY, HLP.RadDeg(AR))
    #
    # Test: MarlinG2/G3
    # P0 = [9.0, 6.0] # PointActual
    # P1 = [2.0, 7.0] # PointTarget
    # Pm = [5.0, 3.0] # PointMiddle
    # [Alpha, Beta, Radius] = P0P1PmABR(P0, P1, Pm)
    # print(HLP.RadDeg(Alpha), HLP.RadDeg(Beta), Radius)
    #
    # Test: Own Drawing
    # P0 = [ 2.0,  2.0] # PointActual
    # P1 = [18.0,  7.5] # PointTarget
    # Pm = [ 8.0, 10.5] # PointMiddle
    # [Alpha, Beta, Radius] = P0P1PmABR(P0, P1, Pm)
    # print(HLP.RadDeg(Alpha), HLP.RadDeg(Beta), Radius)
