#
# Command
#
#
#----------------------------------------------
#
#----------------------------------------------
import Define as DEF
import Helper as HLP
import Parameter as PAR
#
#------------------------------------------------------------
#   GCommand - Base
#------------------------------------------------------------
class CCommand:
    #
    def __init__(self, code, parameterlist):
        self.Code = code
        self.Parameterlist = parameterlist
        return
    #
    def Text(self):
        Result = self.Code
        for P in self.Parameterlist:
            Result = '{0} {1}'.format(Result, P.Text())
        return Result
    #
    def ExecuteController(self):
        Result = True;
        print('ExecuteController[{0}] ...'.format(self.Text()))
        return Result
    #
    def ExecuteSimulator(self):
        Result = True;
        print('ExecuteSimulator[{0}] ...'.format(self.Text()))
        return Result
#
#------------------------------------------------------------
#   GCommand
#------------------------------------------------------------
class CGCommand(CCommand):
    #
    def __init__(self, code, parameterlist):
        super().__init__(code, parameterlist)
        return
#
#------------------------------------------------------------
#   MCommand
#------------------------------------------------------------
class CMCommand(CCommand):
    #
    def __init__(self, code, parameterlist):
        super().__init__(code, parameterlist)
        return
#
#------------------------------------------------------------
#   Comment
#------------------------------------------------------------
class CComment(CCommand):
    #
    def __init__(self, text):
        super().__init__(CODE_COMMENT, [PAR.CText(text)])
        return


#
#
class CCommandlist(list):
    #
    def __init__(self):
        self.Tokenlist = []
        return
    #
    def Lines(self):
        Result = '*** Commandlist[{0}]:'.format(len(self))
        for C in self:
            Result = ('{0}\r\nCommand[{1}]'.format(Result, C.Text()))
        return Result
    #
    def WriteToFile(self, filename):
        FileCommand = open(filename, 'w')
        FileCommand.write('; \n; {0} \n; '.format(filename))
        for C in self:
            FileCommand.write('\r' + C.Text())
        FileCommand.close()
        return
    #
    def BuildGParameterlist(self, index):
        Parameterlist = []
        while (index < len(self.Tokenlist)):
            Token = self.Tokenlist[index]
            print('### ', Token)
            if (DEF.CODE_X == Token[0]):
                Parameterlist.append(PAR.CXParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_Y == Token[0]):
                Parameterlist.append(PAR.CYParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_Z == Token[0]):
                Parameterlist.append(PAR.CZParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_I == Token[0]):
                Parameterlist.append(PAR.CIParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_J == Token[0]):
                Parameterlist.append(PAR.CJParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_K == Token[0]):
                Parameterlist.append(PAR.CKParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_L == Token[0]):
                Parameterlist.append(PAR.CLParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_N == Token[0]):
                Parameterlist.append(PAR.CNParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_P == Token[0]):
                Parameterlist.append(PAR.CPParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_R == Token[0]):
                Parameterlist.append(PAR.CRParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_S == Token[0]):
                Parameterlist.append(PAR.CSParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_T == Token[0]):
                Parameterlist.append(PAR.CTParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_F == Token[0]):
                Parameterlist.append(PAR.CFParameter(Token[1:]))
                index += 1
            else:
                break;
        return [index, Parameterlist]
    #
    def BuildGCommand(self, index):
        if (DEF.CODE_G0 == self.Tokenlist[index]):
            [index,  Parameterlist] = self.BuildGParameterlist(1 + index)
            return [index, CGCommand(DEF.CODE_G0, Parameterlist)]
        if (DEF.CODE_G00 == self.Tokenlist[index]):
            [index,  Parameterlist] = self.BuildGParameterlist(1 + index)
            return [index, CGCommand(DEF.CODE_G00, Parameterlist)]
        if (DEF.CODE_G01 == self.Tokenlist[index]):
            [index,  Parameterlist] = self.BuildGParameterlist(1 + index)
            return [index, CGCommand(DEF.CODE_G01, Parameterlist)]
        if (DEF.CODE_G02 == self.Tokenlist[index]):
            [index,  Parameterlist] = self.BuildGParameterlist(1 + index)
            return [index, CGCommand(DEF.CODE_G02, Parameterlist)]
        if (DEF.CODE_G17 == self.Tokenlist[index]):
            [index,  Parameterlist] = self.BuildGParameterlist(1 + index)
            return [index, CGCommand(DEF.CODE_G17, Parameterlist)]
        if (DEF.CODE_G20 == self.Tokenlist[index]):
            [index,  Parameterlist] = self.BuildGParameterlist(1 + index)
            return [index, CGCommand(DEF.CODE_G20, Parameterlist)]
        if (DEF.CODE_G54 == self.Tokenlist[index]):
            [index,  Parameterlist] = self.BuildGParameterlist(1 + index)
            return [index, CGCommand(DEF.CODE_G54, Parameterlist)]
        if (DEF.CODE_G80 == self.Tokenlist[index]):
            [index,  Parameterlist] = self.BuildGParameterlist(1 + index)
            return [index, CGCommand(DEF.CODE_G80, Parameterlist)]
        if (DEF.CODE_G90 == self.Tokenlist[index]):
            [index,  Parameterlist] = self.BuildGParameterlist(1 + index)
            return [index, CGCommand(DEF.CODE_G90, Parameterlist)]
        if (DEF.CODE_G94 == self.Tokenlist[index]):
            [index,  Parameterlist] = self.BuildGParameterlist(1 + index)
            return [index, CGCommand(DEF.CODE_G94, Parameterlist)]
        HLP.Error('Invalid MCommand')
        index += 1
        return [index, None]
    #
    def BuildMCommand(self, index):
        DEF.Error('Invalid MCommand')
        index += 1
        return [index, None]
    #
    def TokenlistCommandParameter(self):
        Index = 0
        Size = len(self.Tokenlist)
        while Index < Size:
            Token = self.Tokenlist[Index]
            # G/M-Command
            if (DEF.CODE_G == Token[0]):
                [Index, Command] = self.BuildGCommand(Index)
                if (None != Command):
                    self.append(Command)
                    print(':::', Command.Text())
            else:
                if (DEF.CODE_M == Token[0]):
                    [Index, Command] = self.BuildMCommand(Index)
                    if (None != Command):
                        self.append(Command)
                else:
                    HLP.Error('Invalid Token')
                    Index += 1
    #
    def ReadFromFile(self, filename):
        FileCommand = open(filename, 'r')
        #self = []
        Lines = FileCommand.readlines()
        self.clear()
        self.Tokenlist = []
        for Line in Lines:
            Line = Line[:-1].strip()
            if (0 < len(Line)):
                PositionComment = Line.find(DEF.CODE_COMMENT)
                if (0 == PositionComment):
                    self.append(CComment(Line[PositionComment:]))
                else:
                    if (0 < PositionComment):
                        self.append(CComment(Line[PositionComment:]))
                        Line = Line[:PositionComment - 1]
                    if (0 < len(Line)):
                        print('>>>' + Line)
                        self.Tokenlist = Line.strip().split(' ')
                        if (0 < len(self.Tokenlist)):
                            self.TokenlistCommandParameter()
    #
    def ExecuteController(self):
        Result = True;
        print('*** Execute Commandlist[{0}] on GRBL-Controller:'.format(len(self)))
        for Command in self:
            Result = Result and Command.ExecuteController()
        return Result
    #
    def ExecuteSimulator(self):
        Result = True;
        print('*** Execute Commandlist[{0}] on Simulator:'.format(len(self)))
        for Command in self:
            Result = Result and Command.ExecuteSimulator()
        return Result
    #
    #
#
#
