#
# Commandlist
#
#
#----------------------------------------------
#
#----------------------------------------------
import Define as DEF
import Helper as HLP
import Parameter as PAR
import Command as CMD
#
class CCommandlist(list):
    #
    def __init__(self):
        self.Tokenlist = []
        return
    #
    def Lines(self):
        Result = '*** Commandlist[{0}]:'.format(len(self))
        for C in self:
            Result = ('{0}\r\nCommand[{1}]'.format(Result, C.Text()))
        return Result
    #
    def WriteToFile(self, filename):
        FileCommand = open(filename, 'w')
        FileCommand.write('; \n; {0} \n; '.format(filename))
        for C in self:
            FileCommand.write('\r' + C.Text())
        FileCommand.close()
        return
    #
    def BuildGParameterlist(self, index):
        Parameterlist = []
        while (index < len(self.Tokenlist)):
            Token = self.Tokenlist[index]
            if (DEF.CODE_X == Token[0]):
                Parameterlist.append(PAR.CXParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_Y == Token[0]):
                Parameterlist.append(PAR.CYParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_Z == Token[0]):
                Parameterlist.append(PAR.CZParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_H == Token[0]):
                Parameterlist.append(PAR.CHParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_I == Token[0]):
                Parameterlist.append(PAR.CIParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_J == Token[0]):
                Parameterlist.append(PAR.CJParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_K == Token[0]):
                Parameterlist.append(PAR.CKParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_L == Token[0]):
                Parameterlist.append(PAR.CLParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_N == Token[0]):
                Parameterlist.append(PAR.CNParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_P == Token[0]):
                Parameterlist.append(PAR.CPParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_R == Token[0]):
                Parameterlist.append(PAR.CRParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_S == Token[0]):
                Parameterlist.append(PAR.CSParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_T == Token[0]):
                Parameterlist.append(PAR.CTParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_F == Token[0]):
                Parameterlist.append(PAR.CFParameter(Token[1:]))
                index += 1
            else:
                break;
        return [index, Parameterlist]
    #
    def BuildGCommand(self, index):
        Token = self.Tokenlist[index]
        if (None != Token):
            if (DEF.CODE_G == Token[0]):
                [index,  Parameterlist] = self.BuildGParameterlist(1 + index)
                GCommand = CMD.CGCommand(Token, Parameterlist)
                return [index, GCommand]
        return [index, None]
    #
    def BuildMCommand(self, index):
        Token = self.Tokenlist[index]
        if (None != Token):
            if (DEF.CODE_M == Token[0]):
                [index,  Parameterlist] = self.BuildGParameterlist(1 + index)
                GCommand = CMD.CGCommand(Token, Parameterlist)
                return [index, GCommand]
        return [index, None]
    #
    def TokenlistCommandParameter(self):
        Index = 0
        Size = len(self.Tokenlist)
        while Index < Size:
            # G-Command
            [Index, Command] = self.BuildGCommand(Index)
            if (None != Command):
                self.append(Command)
                # debug print(':G:', Command.Text())
            else: # M-Command
                [Index, Command] = self.BuildMCommand(Index)
                if (None != Command):
                    self.append(Command)
                    # debug print(':M:', Command.Text())
                else:
                    Token = self.Tokenlist[Index]
                    SComment = ''
                    if (DEF.CODE_COMMENT == Token[0]):
                        while (Index < Size):
                            SComment += self.Tokenlist[Index] + ' '
                            Index += 1
                        # debug print(SComment)
                        PS = SComment.find(DEF.CODE_COMMENT)
                        if (0 <= PS):
                            SComment = SComment[1 + PS:].strip()
                        # debug print(SComment)
                        if (0 < len(SComment)):
                            # debug print('.C.', SComment)
                            self.append(CMD.CComment(SComment))
                    else:
                        HLP.Error('Invalid Token [' + Token + ']')
                        Index = Size
                        return False
        return True
    #
    def ReadFromFile(self, filename):
        FileCommand = open(filename, 'r')
        Lines = FileCommand.readlines()
        self.clear()
        self.Tokenlist = None
        for Line in Lines:
            Line = Line[:-1].strip()
            if (0 < len(Line)):
                # debug print('>>>' + Line)
                self.Tokenlist = Line.strip().split(' ')
                if (0 < len(self.Tokenlist)):
                    if not(self.TokenlistCommandParameter()):
                        return False
        return True
#
#

