#
import time as TIM
from enum import Enum
#
import Define as DEF
import Helper as HLP
import Task as TSK
import Command as CMD
import Commandlist as CML
import CommandExecutor as CEX
#

class EStateInterface(Enum):
    Idle = 0
    TransmitCommand = 1
    ReceiveCommand = 2
    ReceiveAnswer = 3
#
class CCommandMachine(CEX.CCommandExecutor):
    #
    def __init__(self, uart):
        super(CCommandMachine, self).__init__(self.CBTaskOnStart,
                                              self.CBTaskOnAbort,
                                              self.CBTaskOnExecute)
        self.Uart = uart
        self.Uart.SetCBOnLineReceived(self.CBOnLineReceived)
        self.RxLines = []
        self.Commandlines = []
        self.State = EStateInterface.Idle
        return
    #--------------------------------------------------------------------
    #   Property
    #--------------------------------------------------------------------
    def IsBusy(self):
        return (0 < len(self.Commandlines))
    #--------------------------------------------------------------------
    #   Callback - Uart
    #--------------------------------------------------------------------
    def CBOnLineReceived(self, rxline):
        if (0 < len(rxline)):
            if ('Grbl' in rxline):
                # debug print('>>>RxD-Comment{' + rxline + '}')
                pass
            else:
                # debug print('>>>RxData{' + rxline + '}')
                self.RxLines.append(rxline)
        else:
            HLP.Error('Invalid Line received')
    #--------------------------------------------------------------------
    #   Callback - Task
    #--------------------------------------------------------------------
    def CBTaskOnStart(self):
        print('ExecuteCommandlist<<<OnStart>>>')
        return
    def CBTaskOnAbort(self):
        print('ExecuteCommandlist<<<OnAbort>>>')
        return
    def CBTaskOnExecute(self):
        if (0 == len(self.Commandlines)):
            TIM.sleep(0.2)
        else: # more than zero commandlines ->
            if (EStateInterface.Idle == self.State):
                self.State = EStateInterface.TransmitCommand
                Commandline = self.Commandlines.pop(0) # pop(0) !!!!
                print('ExecuteCommand[' + Commandline + ']')
                self.Uart.WriteLine(Commandline)
                self.State = EStateInterface.ReceiveCommand
            elif (EStateInterface.ReceiveCommand == self.State):
                if (0 < len(self.RxLines)):
                    RxLine = self.RxLines.pop()
                    if ('ok' == RxLine):
                        self.State = EStateInterface.ReceiveAnswer
                    # elif ('error:33' == RxLine):
                    #     self.State = EStateInterface.ReceiveAnswer
                    else:
                        HLP.Error('Invalid Command received')
                        self.State = EStateInterface.Idle
            elif (EStateInterface.ReceiveAnswer == self.State):
                if (0 < len(self.RxLines)):
                    RxLine = self.RxLines.pop()
                    if ('ok' == RxLine):
                        self.State = EStateInterface.Idle
                    else:
                        HLP.Error('Invalid Response received')
                        self.State = EStateInterface.Idle
            else:
                HLP.Error('Invalid Interface-State')
                self.State = EStateInterface.Idle
        return
    #--------------------------------------------------------------------
    #   Main
    #--------------------------------------------------------------------
    def PushCommandLine(self, commandline):
        # debug
        print('>>> PushCommandLine[' + commandline + ']')
        self.Commandlines.append(commandline)
        return
    def IgnoreCommandLine(self, commandline):
        # debug
        print('--- IgnoreCommandLine[' + commandline + ']')
        return
    #
    def BuildGCodeCommands(self, commandlist):
        Result = True;
        print('*** CommandMachine[{0}]'.format(len(commandlist)))
        for Command in commandlist:
            #- C ------------------------------------------------
            if (DEF.CODE_COMMENT == Command.Code):
                # debug Text = 'Comment[' + Command.Code + ' '
                # for P in Command.Parameterlist:
                #     Text += P.Value
                # Text += ']'
                # debug print(Text)
                CommandLine = Command.BuildExecuteMachine()
                self.IgnoreCommandLine(CommandLine)
            #- G ------------------------------------------------
            elif ('G00' == Command.Code) or ('G0' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Rapid Positioning')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('G01' == Command.Code) or ('G1' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Cut Line Moving')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('G02' == Command.Code) or ('G2' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Cut Arc Clockwise')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('G03' == Command.Code) or ('G3' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Cut Arc Counter-Clockwise')
                CommandLine = Command.BuildExecuteMachine()
                self.ExecuteCommandLine(CommandLine)
            elif ('G17' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Arc in XY-Plane')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('G18' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Arc in XZ-Plane')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('G19' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Arc in YZ-Plane')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('G20' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Unit Inches')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('G21' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Unit Millimeters')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('G40' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Cutter Compensation Off')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('G49' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Cancel Tool Length Offset')
                CommandLine = Command.BuildExecuteMachine()
                self.IgnoreCommandLine(CommandLine)
            elif ('G53' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Use Machine Coordinates')
                CommandLine = Command.BuildExecuteMachine()
                self.IgnoreCommandLine(CommandLine)
            elif ('G54' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Activate Saved Origin')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('G80' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Cancel')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('G90' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Mode Absolute')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('G91' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Mode Absolute')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            #- M ------------------------------------------------
            elif ('M0' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Pause')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('M1' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Pause on StopSwitch')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('M2' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Program End')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('M3' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Start Spindle Clockwise')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('M4' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Start Spindle CounterClockwise')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('M5' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Stop Spindle')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('M6' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Select Tool')
                CommandLine = Command.BuildExecuteMachine()
                self.IgnoreCommandLine(CommandLine)
            elif ('M8' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Coolant On')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('M9' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Coolant Off')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('M25' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Pause SDCard Execution')
                CommandLine = Command.BuildExecuteMachine()
                self.IgnoreCommandLine(CommandLine)
            elif ('M30' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Program End')
                CommandLine = Command.BuildExecuteMachine()
                self.PushCommandLine(CommandLine)
            elif ('M99' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Return from SubProgram')
                CommandLine = Command.BuildExecuteMachine()
                self.IgnoreCommandLine(CommandLine)
                # debug print(self.Commandlines)
            #- E ------------------------------------------------
            else:
                DEF.Error('Invalid Command [' + Command.Code + ']')
                Result = false
                break
        return Result
