#
import time as TIM
#
import Define as DEF
import Helper as HLP
import Uart as URT
import Parameter as P
import Command as C
import Commandlist as CL
import CommandExecutor as CMX
import CommandViewer as CMV
import CommandMachine as CMM
import CommandCommon as CMC
#
#----------------------------------------------
if '__main__' == __name__:
    print('\r\n*** GCodeCommandInterpreter - start')
    print('>>> Open Program:')
    #
    try:
        UartGrblController = URT.CUart()
        UartGrblController.Open('COM6', '115200', 'N', '8', '1', 'None')
        TIM.sleep(3)
        #
        print('>>> Read Commandlist:')
        Commandlist = CL.CCommandlist()
        # if (Commandlist.ReadFromFile('AAAmini.gcode')): #'22092300847_ExamplePath.gcode')): #'EP.gcode')): #'AA.gcode')#'demo.gcode')
        if (Commandlist.ReadFromFile('AAA.gcode')):
            # debug print(Commandlist.Lines())
            #
            CommandExecutor = CMX.CCommandExecutor()
            if (CommandExecutor.BuildGCodeCommands(Commandlist)):
                GCodelist = CommandExecutor.GetGCodelist()
                #debug
                print('>>> GCodelist[' + str(len(GCodelist)) + ']:')
                print(GCodelist)
                #
                # 1. Possibility: GCodelist -> CommandMachine
                CommandMachine = CMM.CCommandMachine(UartGrblController)
                print('>>> Execute GCodelist[' + str(len(GCodelist)) + ']:')
                CommandMachine.Start(GCodelist)
                while (CommandMachine.IsBusy()):
                    TIM.sleep(1.0)
                CommandMachine.Abort()
                #
                # 2. Possibility: GCodelist -> CommandSimulator
                # CommandSimulator.Start(Commandlist)
                # while (CommandSimulator.IsBusy()):
                #     TIM.sleep(1.0)
                # CommandSimulator.Abort()
    except:
        HLP.Error('Global in Main')
    finally:
        print('>>> Close Program:')
        UartGrblController.Close()
    #
    print('*** GCodeCommandInterpreter - end')
    #
    #
#
#
#-------------------------------------------------------------------------------



        #CommandViewer = CMV.CCommandViewer()
        #CommandViewer.Execute(Commandlist)
        #
