#
import Define as DEF
import Task as TSK
import Command as CMD
import Commandlist as CML
#
class CCommandConverter():
    #
    def __init__(self):
        self.GCodelist = []
        return
    #--------------------------------------------------------------------
    #   Property
    #--------------------------------------------------------------------
    def GetGCodelist(self):
        return self.GCodelist
    #--------------------------------------------------------------------
    #   Main
    #--------------------------------------------------------------------
    def PushGCode(self, gcode):
        # debug
        print('>>> PushGCode[' + gcode + ']')
        self.GCodelist.append(gcode)
        return
    def IgnoreGCode(self, gcode):
        # debug
        print('--- IgnoreGCode[' + gcode + ']')
        return
    #
    def BuildGCodeFromCommandlist(self, commandlist):
        Result = True;
        self.GCodelist = []
        print('*** CommandMachine[{0}]'.format(len(commandlist)))
        for Command in commandlist:
            #- C ------------------------------------------------
            if (DEF.CODE_COMMENT == Command.Code):
                # debug Text = 'Comment[' + Command.Code + ' '
                # for P in Command.Parameterlist:
                #     Text += P.Value
                # Text += ']'
                # debug print(Text)
                GCode = Command.BuildGCode()
                self.IgnoreGCode(GCode)
            #- G ------------------------------------------------
            elif ('G00' == Command.Code) or ('G0' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Rapid Positioning')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('G01' == Command.Code) or ('G1' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Cut Line Moving')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('G02' == Command.Code) or ('G2' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Cut Arc Clockwise')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('G03' == Command.Code) or ('G3' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Cut Arc Counter-Clockwise')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('G17' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Arc in XY-Plane')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('G18' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Arc in XZ-Plane')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('G19' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Arc in YZ-Plane')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('G20' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Unit Inches')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('G21' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Unit Millimeters')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('G40' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Cutter Compensation Off')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('G49' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Cancel Tool Length Offset')
                GCode = Command.BuildGCode()
                self.IgnoreGCode(GCode)
            elif ('G53' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Use Machine Coordinates')
                GCode = Command.BuildGCode()
                self.IgnoreGCode(GCode)
            elif ('G54' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Activate Saved Origin')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('G80' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Cancel')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('G90' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Mode Absolute')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('G91' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Mode Absolute')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            #- M ------------------------------------------------
            elif ('M0' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Pause')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('M1' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Pause on StopSwitch')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('M2' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Program End')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('M3' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Start Spindle Clockwise')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('M4' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Start Spindle CounterClockwise')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('M5' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Stop Spindle')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('M6' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Select Tool')
                GCode = Command.BuildGCode()
                self.IgnoreGCode(GCode)
            elif ('M8' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Coolant On')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('M9' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Coolant Off')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('M25' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Pause SDCard Execution')
                GCode = Command.BuildGCode()
                self.IgnoreGCode(GCode)
            elif ('M30' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Program End')
                GCode = Command.BuildGCode()
                self.PushGCode(GCode)
            elif ('M99' == Command.Code):
                # debug print(Command.BuildCommandLine() + '; Return from SubProgram')
                GCode = Command.BuildGCode()
                self.IgnoreGCode(GCode)
                # debug print(self.Commandlines)
            #- E ------------------------------------------------
            else:
                DEF.Error('Invalid Command [' + Command.Code + ']')
                Result = false
                break
        return Result

    #
#
#
