#
import time as TIM
from enum import Enum
#
import Define as DEF
import Helper as HLP
import Task as TSK
import Command as CMD
import Commandlist as CML
#
class EStateInterface(Enum):
    Idle = 0
    TransmitCommand = 1
    ReceiveCommand = 2
    ReceiveAnswer = 3
#
class CCommandMachine():
    #
    def __init__(self, uart):
        #super(CCommandMachine, self).__init__()
        self.Task = TSK.CTask(self.CBTaskOnStart,
                              self.CBTaskOnAbort,
                              self.CBTaskOnExecute)
        self.Uart = uart
        self.Uart.SetCBOnLineReceived(self.CBOnLineReceived)
        self.RxLines = []
        self.State = EStateInterface.Idle
        self.GCodelist = []
        return
    #--------------------------------------------------------------------
    #   Property
    #--------------------------------------------------------------------
    def IsBusy(self):
        return (0 < len(self.GCodelist))
    #
    def Start(self, gcodelist):
        self.GCodelist = []
        self.GCodelist = gcodelist
        self.Task.Start()
    #
    def Abort(self):
        self.Task.Abort()
    #
    #--------------------------------------------------------------------
    #   Callback - Uart
    #--------------------------------------------------------------------
    def CBOnLineReceived(self, rxline):
        if (0 < len(rxline)):
            if ('Grbl' in rxline):
                # debug print('>>>RxD-Comment{' + rxline + '}')
                pass
            else:
                # debug print('>>>RxData{' + rxline + '}')
                self.RxLines.append(rxline)
        else:
            HLP.Error('Invalid Line received')
    #--------------------------------------------------------------------
    #   Callback - Task
    #--------------------------------------------------------------------
    def CBTaskOnStart(self):
        # debug print('ExecuteCommandlist<<<OnStart>>>')
        return
    def CBTaskOnAbort(self):
        # debug print('ExecuteCommandlist<<<OnAbort>>>')
        return
    def CBTaskOnExecute(self):
        if (0 == len(self.GCodelist)):
            TIM.sleep(0.2)
        else: # more than zero GCodes ->
            if (EStateInterface.Idle == self.State):
                self.State = EStateInterface.TransmitCommand
                GCode = self.GCodelist.pop(0) # pop(0) !!!!
                print('ExecuteGCode[' + GCode + ']')
                self.Uart.WriteLine(GCode)
                self.State = EStateInterface.ReceiveCommand
            elif (EStateInterface.ReceiveCommand == self.State):
                if (0 < len(self.RxLines)):
                    RxLine = self.RxLines.pop()
                    if ('ok' == RxLine):
                        self.State = EStateInterface.ReceiveAnswer
                    # elif ('error:33' == RxLine):
                    #     self.State = EStateInterface.ReceiveAnswer
                    else:
                        HLP.Error('Invalid Command received')
                        self.State = EStateInterface.Idle
            elif (EStateInterface.ReceiveAnswer == self.State):
                if (0 < len(self.RxLines)):
                    RxLine = self.RxLines.pop()
                    if ('ok' == RxLine):
                        self.State = EStateInterface.Idle
                    else:
                        HLP.Error('Invalid Response received')
                        self.State = EStateInterface.Idle
            else:
                HLP.Error('Invalid Interface-State')
                self.State = EStateInterface.Idle
        return
    #
    #
#
#
