#
import time as TIM
#
import Define as DEF
import Helper as HLP
import Task as TSK
import Uart as URT
import Parameter as P
import Command as C
import GCodeConverter as GCV
import GCodeReport as GCR
import GCodeHardware as GCH
#
import WindowMain as WM
#
#--------------------------------------------------------------------
#   Callback - Task - GCodeExecution
#--------------------------------------------------------------------
def CBTaskOnStart(task):
    #print('ExecuteGCode<<<OnStart>>>')
    return
def CBTaskOnAbort(task):
    #print('ExecuteGCode<<<OnAbort>>>')
    return
def CBTaskOnExecute(task):
    print('>>> ExecuteGCodelist[{0}]: begin'.format(len(GCodeList)))
    for GCode in GCodeList:
        #-----------------------------------------------------
        # GCodeReport
        #-----------------------------------------------------
        WindowMain.FrameGCodeReport.SendCommand(GCode)
        [Result, Message] = GCodeReport.ExecuteGCode(GCode)
        WindowMain.FrameGCodeReport.SendResult(Result, Message, GCode)
        if not(Result):
            HLP.Error(Message)
            break
        while (GCodeReport.IsBusy()):
            pass
        #-----------------------------------------------------
        # GCodeHardware
        #-----------------------------------------------------
        WindowMain.FrameGCodeHardware.SendCommand(GCode)
        [Result, Message] = GCodeHardware.ExecuteGCode(GCode)
        WindowMain.FrameGCodeHardware.SendResult(Result, Message, GCode)
        if not(Result):
            HLP.Error(Message)
            break
        while (GCodeHardware.IsBusy()):
            pass
        #
    print('>>> ExecuteGCodelist[{0}]: end'.format(len(GCodeList)))
    task.Abort()
    return
#
#--------------------------------------------------------------------
#   Field - Global
#--------------------------------------------------------------------
GCodeConverter = GCV.CGCodeConverter()
GCodeReport = GCR.CGCodeReport()
UartGrblController = URT.CUart()
GCodeHardware = GCH.CGCodeHardware(UartGrblController)
GCodeList = []
TaskExecution = TSK.CTask('TaskExecution', CBTaskOnStart,
                          CBTaskOnAbort, CBTaskOnExecute)
#
#--------------------------------------------------------------------
#   Callback - Main
#--------------------------------------------------------------------
def OnWindowMainDelete():
    try:
        WindowMain.WriteInitdata(DEF.NAME_INITFILE)
        TaskExecution.Abort()
        UartGrblController.Close()
    except:
        pass
#
#----------------------------------------------
if '__main__' == __name__:
    print("*** " + DEF.APPLICATION_TITLE + ": begin")
    #
    #----------------------------------------------
    # Activate WindowMain
    #----------------------------------------------
    WindowMain = WM.CWindowMain(OnWindowMainDelete)
    WindowMain.Initialise(UartGrblController)
    #----------------------------------------------
    # Activate Uart (with GRBL-Reset)
    #----------------------------------------------
    UartGrblController.SetWaitingForLineReceived()
    UartGrblController.Open('COM9', '115200', 'N', '8', '1', 'None')
    while (UartGrblController.IsWaitingForLineReceived):
        pass
    #----------------------------------------------
    # Load/Convert GCode-File
    #----------------------------------------------
    FileEntry = 'AAAmini.gcode'
    print('>>> Read GCodeList from File[{0}]:'.format(FileEntry))
    [GCodeList, GCodeLines] = GCodeConverter.ReadFromFile(FileEntry)
    #print('>>> GCodeLines:')
    #print(GCodeLines)
    print('>>> GCodeList:')
    print(GCodeList.Text(), end='')
    #----------------------------------------------
    # Start GCode-Execution
    #----------------------------------------------
    TaskExecution.Start()
    #----------------------------------------------
    # Start WindowMain
    #----------------------------------------------
    WindowMain.Execute()
    #----------------------------------------------
    # Free WindowMain
    #----------------------------------------------
    if (TaskExecution.IsBusy()):
        TaskExecution.Abort()
    if (UartGrblController.IsOpen()):
        UartGrblController.Close()
    #
    print("*** " + DEF.APPLICATION_TITLE + ": end")
    #
    #
#
#


# GCodeSimulator.ExecuteGCode(GCode)
# while (GCodeSimulator.IsBusy()): #  or GCodeHardware.IsBusy()):


###########################################################################
#
#

