#
import matplotlib as mpl
from mpl_toolkits.mplot3d import Axes3D
import matplotlib.pyplot as PLT
import numpy as NP
#
class CParameter3D():
    #
    def __init__(self, sizeplot, elevation, azimut,
                 limitxlow, limitxhigh, 
                 limitylow, limityhigh, 
                 limitzlow, limitzhigh):
        self.SizePlot = sizeplot
        self.Elevation = elevation
        self.Azimut = azimut
        self.LimitXlow = limitxlow
        self.LimitXhigh = limitxhigh
        self.LimitYlow = limitylow
        self.LimitYhigh = limityhigh
        self.LimitZlow = limitzlow
        self.LimitZhigh = limitzhigh
    #
    def SizePlot(self):
        return self.SizePlot
    def Elevation(self):
        return self.Elevation
    def Azimut(self):
        return self.Azimut
    def LimitXlow(self):
        return self.LimitXlow
    def LimitXhigh(self):
        return self.LimitXhigh
    def LimitYlow(self):
        return self.LimitYlow
    def LimitYhigh(self):
        return self.LimitYhigh
    def LimitZlow(self):
        return self.LimitZlow
    def LimitZhigh(self):
        return self.LimitZhigh
#    
class CPlot3D():
    #
    def __init__(self):
        return
    #
    def Plot(self, parameter3d, curves3d):
        Figure = PLT.figure(figsize = (parameter3d.SizePlot, parameter3d.SizePlot))
        Axis = PLT.axes(projection = '3d')
        Axis.view_init(elev = parameter3d.Elevation, azim = parameter3d.Azimut)
        Axis.set_box_aspect(aspect = (1.0, 1.0, 1.0))
        Axis.set_xlim3d(parameter3d.LimitXlow, parameter3d.LimitXhigh)
        Axis.set_ylim3d(parameter3d.LimitYlow, parameter3d.LimitYhigh)
        Axis.set_zlim3d(parameter3d.LimitZlow, parameter3d.LimitZhigh) 
        #
        for Curve in curves3d:
            if ('' != Curve.PointColor):
                Axis.plot(Curve.VX, Curve.VY, Curve.VZ, 
                          c = Curve.PointColor, marker = Curve.PointMarker)
            if ('' != Curve.CurveColor):
                Axis.plot(Curve.VX, Curve.VY, Curve.VZ, c = Curve.CurveColor)
        #
        PLT.show()
    #
#    