#
# ------------------------------------------------------------------
#   FrameSetup
# ------------------------------------------------------------------
#   Version: 00V02
#   Date   : 221005
#   Time   : 1949
#   Author : OMDevelop
#
import tkinter as TKI
from tkinter import ttk as TTK
#
import Define as DEF
import Helper as HLP
import Uart as URT
#
import FrameSetupUart as FSU
import FrameSetupGlobal as FSG
#
#------------------------------------------------------------------
#   Global Constant
#------------------------------------------------------------------
INITDATA_SECTION                = 'FrameSetup'
#
SPACE_COLUMN                    = '    '
TEXT_OPEN                       = 'Open'
TEXT_CLOSE                      = 'Close'
#
NAME_ISOPEN                     = 'IsOpen'
INIT_ISOPEN                     = 'False'
#
#------------------------------------------------------------------
#   Type
#------------------------------------------------------------------
class CFrameSetup(TKI.Frame):
    # Row0
    # btnComport = None
    # SComport = None
    # cbxComport = None
    # lblBaudrate = None
    # SBaudrate = None
    # cbxBaudrate = None
    # Row1
    # Row2
    # Row3
    #---------------------------------------------------------------------
    # Constructor
    #---------------------------------------------------------------
    def __init__(self, window):
        TKI.Frame.__init__(self, window, padx = DEF.PAD_X, \
                           pady = DEF.PAD_Y, bg = "#E2E2E2")
                           # width = 610, height = 532,
        #--------------------------------------------------------------
        # Controls - Row0
        #--------------------------------------------------------------
        self.FrameSetupUart = FSU.CFrameSetupUart(self)
        self.FrameSetupUart.grid(row = 0, column = 0, sticky = "WENS",
                                 padx = DEF.PAD_X, pady = DEF.PAD_Y)
        self.FrameSetupUart.SetCBOnStateUartChanged(self.OnStateUartChanged)
        #--------------------------------------------------------------
        # Controls - Row1
        #--------------------------------------------------------------
        self.FrameSetupGlobal = FSG.CFrameSetupGlobal(self)
        self.FrameSetupGlobal.grid(row = 1, column = 0, sticky = "WENS",
                                   padx = DEF.PAD_X, pady = DEF.PAD_Y)
        #--------------------------------------------------------------
        # Controls - Row2
        #--------------------------------------------------------------
        #--------------------------------------------------------------
        # Controls - Row3
        #--------------------------------------------------------------
        #
    #---------------------------------------------------------------------
    # Property
    #---------------------------------------------------------------
    def SetLinkUart(self, uart):
        self.FrameSetupUart.SetLinkUart(uart)
        return
    #---------------------------------------------------------------------
    # Callback
    #---------------------------------------------------------------------
    def OnStateUartChanged(self, state):
        # debug print('### OnStateUartChanged[' + str(state) + ']')
        if (FSU.STATE_NOUARTS == state):
            self.FrameSetupGlobal.GCodeHardwareDisable()
        elif (FSU.STATE_UARTOPEN == state):
            self.FrameSetupGlobal.GCodeHardwareEnable()
        elif (FSU.STATE_UARTCLOSE == state):
            self.FrameSetupGlobal.GCodeHardwareDisable()
    #---------------------------------------------------------------------
    # Helper
    #---------------------------------------------------------------------
    def Open(self):
        return
    #
    def Close(self):
        return
    #
    def OnOpenClose(self):
        return
    #---------------------------------------------------------------------
    # Initdata
    #---------------------------------------------------------------------
    def ReadInitdata(self, readinitdata):
        return True
    #
    def WriteInitdata(self, writeinitdata):
        writeinitdata.WriteSection(INITDATA_SECTION)
        return True
    #
    #
#
#






